/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.DataFilterMapItem;

@Embeddable
public class DataFilterMap {
    @JsonProperty(value="@type")
    @Column(name="dfm_type")
    private String type;
    @JsonProperty(value="@baseType")
    @Column(name="dfm_base_type")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    @Column(name="dfm_schema_location")
    private String schemaLocation;
    @ElementCollection(targetClass=DataFilterMapItem.class)
    @JsonProperty(value="mappings")
    private List<@Valid DataFilterMapItem> mappings = new ArrayList<DataFilterMapItem>();

    public DataFilterMap() {
    }

    public DataFilterMap(String type) {
        this.type = type;
    }

    public DataFilterMap type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DataFilterMap baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public DataFilterMap schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public DataFilterMap mappings(List<@Valid DataFilterMapItem> mappings) {
        this.mappings = mappings;
        return this;
    }

    public DataFilterMap addMappingsItem(DataFilterMapItem mappingsItem) {
        if (this.mappings == null) {
            this.mappings = new ArrayList<DataFilterMapItem>();
        }
        this.mappings.add(mappingsItem);
        return this;
    }

    @Valid
    @Schema(name="mappings", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid List<@Valid DataFilterMapItem> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<@Valid DataFilterMapItem> mappings) {
        this.mappings = mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFilterMap dataFilterMap = (DataFilterMap)o;
        return Objects.equals(this.type, dataFilterMap.type) && Objects.equals(this.baseType, dataFilterMap.baseType) && Objects.equals(this.schemaLocation, dataFilterMap.schemaLocation) && Objects.equals(this.mappings, dataFilterMap.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.mappings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataFilterMap {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    mappings: ").append(this.toIndentedString(this.mappings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

