/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.AttachmentRef;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.pm628.model.Characteristic;
import org.etsi.osl.tmf.pm628.model.DataFilterMap;
import org.etsi.osl.tmf.pm628.model.ExternalIdentifier;
import org.etsi.osl.tmf.pm628.model.Feature;
import org.etsi.osl.tmf.pm628.model.IntentRef;
import org.etsi.osl.tmf.pm628.model.LogicalResource;
import org.etsi.osl.tmf.pm628.model.RelatedPartyRefOrPartyRoleRef;
import org.etsi.osl.tmf.pm628.model.RelatedPlaceRef;
import org.etsi.osl.tmf.pm628.model.RelatedResourceOrderItem;
import org.etsi.osl.tmf.pm628.model.ResourceRelationship;
import org.etsi.osl.tmf.pm628.model.ResourceStatusType;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;

@Entity(name="PM628_DAE")
public class DataAccessEndpoint
extends LogicalResource {
    @JsonProperty(value="uri")
    private URI uri;
    @Embedded
    @JsonProperty(value="uriQueryFilter")
    private DataFilterMap uriQueryFilter;
    @JsonProperty(value="apiType")
    private String apiType;

    public DataAccessEndpoint() {
    }

    public DataAccessEndpoint(String atType) {
        super(atType);
    }

    public DataAccessEndpoint uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @Valid
    @Schema(name="uri", description="URI for using the data access API", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public DataAccessEndpoint uriQueryFilter(DataFilterMap uriQueryFilter) {
        this.uriQueryFilter = uriQueryFilter;
        return this;
    }

    @Valid
    @Schema(name="uriQueryFilter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public DataFilterMap getUriQueryFilter() {
        return this.uriQueryFilter;
    }

    public void setUriQueryFilter(DataFilterMap uriQueryFilter) {
        this.uriQueryFilter = uriQueryFilter;
    }

    public DataAccessEndpoint apiType(String apiType) {
        this.apiType = apiType;
        return this;
    }

    @Schema(name="apiType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getApiType() {
        return this.apiType;
    }

    public void setApiType(String apiType) {
        this.apiType = apiType;
    }

    @Override
    public DataAccessEndpoint value(String value) {
        super.value(value);
        return this;
    }

    @Override
    public DataAccessEndpoint category(String category) {
        super.category(category);
        return this;
    }

    @Override
    public DataAccessEndpoint description(String description) {
        super.description(description);
        return this;
    }

    @Override
    public DataAccessEndpoint name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public DataAccessEndpoint endOperatingDate(OffsetDateTime endOperatingDate) {
        super.endOperatingDate(endOperatingDate);
        return this;
    }

    @Override
    public DataAccessEndpoint administrativeState(ResourceAdministrativeStateType administrativeState) {
        super.administrativeState(administrativeState);
        return this;
    }

    @Override
    public DataAccessEndpoint operationalState(ResourceOperationalStateType operationalState) {
        super.operationalState(operationalState);
        return this;
    }

    @Override
    public DataAccessEndpoint resourceStatus(ResourceStatusType resourceStatus) {
        super.resourceStatus(resourceStatus);
        return this;
    }

    @Override
    public DataAccessEndpoint usageState(ResourceUsageStateType usageState) {
        super.usageState(usageState);
        return this;
    }

    @Override
    public DataAccessEndpoint validFor(TimePeriod validFor) {
        super.validFor(validFor);
        return this;
    }

    @Override
    public DataAccessEndpoint note(List<Note> note) {
        super.note(note);
        return this;
    }

    @Override
    public DataAccessEndpoint addNoteItem(Note noteItem) {
        super.addNoteItem(noteItem);
        return this;
    }

    @Override
    public DataAccessEndpoint resourceOrderItem(List<RelatedResourceOrderItem> resourceOrderItem) {
        super.resourceOrderItem(resourceOrderItem);
        return this;
    }

    @Override
    public DataAccessEndpoint addResourceOrderItemItem(RelatedResourceOrderItem resourceOrderItemItem) {
        super.addResourceOrderItemItem(resourceOrderItemItem);
        return this;
    }

    @Override
    public DataAccessEndpoint place(List<RelatedPlaceRef> place) {
        super.place(place);
        return this;
    }

    @Override
    public DataAccessEndpoint addPlaceItem(RelatedPlaceRef placeItem) {
        super.addPlaceItem(placeItem);
        return this;
    }

    @Override
    public DataAccessEndpoint relatedParty(List<RelatedPartyRefOrPartyRoleRef> relatedParty) {
        super.relatedParty(relatedParty);
        return this;
    }

    @Override
    public DataAccessEndpoint addRelatedPartyItem(RelatedPartyRefOrPartyRoleRef relatedPartyItem) {
        super.addRelatedPartyItem(relatedPartyItem);
        return this;
    }

    @Override
    public DataAccessEndpoint resourceRelationship(List<ResourceRelationship> resourceRelationship) {
        super.resourceRelationship(resourceRelationship);
        return this;
    }

    @Override
    public DataAccessEndpoint addResourceRelationshipItem(ResourceRelationship resourceRelationshipItem) {
        super.addResourceRelationshipItem(resourceRelationshipItem);
        return this;
    }

    @Override
    public DataAccessEndpoint resourceCharacteristic(List<Characteristic> resourceCharacteristic) {
        super.resourceCharacteristic(resourceCharacteristic);
        return this;
    }

    @Override
    public DataAccessEndpoint addResourceCharacteristicItem(Characteristic resourceCharacteristicItem) {
        super.addResourceCharacteristicItem(resourceCharacteristicItem);
        return this;
    }

    @Override
    public DataAccessEndpoint attachment(List<AttachmentRef> attachment) {
        super.attachment(attachment);
        return this;
    }

    @Override
    public DataAccessEndpoint addAttachmentItem(AttachmentRef attachmentItem) {
        super.addAttachmentItem(attachmentItem);
        return this;
    }

    @Override
    public DataAccessEndpoint resourceSpecification(ResourceSpecificationRef resourceSpecification) {
        super.resourceSpecification(resourceSpecification);
        return this;
    }

    @Override
    public DataAccessEndpoint startOperatingDate(OffsetDateTime startOperatingDate) {
        super.startOperatingDate(startOperatingDate);
        return this;
    }

    @Override
    public DataAccessEndpoint resourceVersion(String resourceVersion) {
        super.resourceVersion(resourceVersion);
        return this;
    }

    @Override
    public DataAccessEndpoint activationFeature(List<Feature> activationFeature) {
        super.activationFeature(activationFeature);
        return this;
    }

    @Override
    public DataAccessEndpoint addActivationFeatureItem(Feature activationFeatureItem) {
        super.addActivationFeatureItem(activationFeatureItem);
        return this;
    }

    @Override
    public DataAccessEndpoint intent(IntentRef intent) {
        super.intent(intent);
        return this;
    }

    @Override
    public DataAccessEndpoint externalIdentifier(List<ExternalIdentifier> externalIdentifier) {
        super.externalIdentifier(externalIdentifier);
        return this;
    }

    @Override
    public DataAccessEndpoint addExternalIdentifierItem(ExternalIdentifier externalIdentifierItem) {
        super.addExternalIdentifierItem(externalIdentifierItem);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataAccessEndpoint dataAccessEndpoint = (DataAccessEndpoint)o;
        return Objects.equals(this.uri, dataAccessEndpoint.uri) && Objects.equals(this.uriQueryFilter, dataAccessEndpoint.uriQueryFilter) && Objects.equals(this.apiType, dataAccessEndpoint.apiType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uri, this.uriQueryFilter, this.apiType, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataAccessEndpoint {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    uriQueryFilter: ").append(this.toIndentedString(this.uriQueryFilter)).append("\n");
        sb.append("    apiType: ").append(this.toIndentedString(this.apiType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

