/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.CharacteristicRelationshipMVO;

public class CharacteristicMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="valueType")
    private String valueType;
    @JsonProperty(value="characteristicRelationship")
    @Valid
    private List<CharacteristicRelationshipMVO> characteristicRelationship;

    public CharacteristicMVO() {
    }

    public CharacteristicMVO(String type) {
        this.type = type;
    }

    public CharacteristicMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CharacteristicMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public CharacteristicMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public CharacteristicMVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="Unique identifier of the characteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public CharacteristicMVO name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Name of the characteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CharacteristicMVO valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(name="valueType", description="Data type of the value of the characteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public CharacteristicMVO characteristicRelationship(List<CharacteristicRelationshipMVO> characteristicRelationship) {
        this.characteristicRelationship = characteristicRelationship;
        return this;
    }

    public CharacteristicMVO addCharacteristicRelationshipItem(CharacteristicRelationshipMVO characteristicRelationshipItem) {
        if (this.characteristicRelationship == null) {
            this.characteristicRelationship = new ArrayList<CharacteristicRelationshipMVO>();
        }
        this.characteristicRelationship.add(characteristicRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="characteristicRelationship", description="Collection of characteristic relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicRelationshipMVO> getCharacteristicRelationship() {
        return this.characteristicRelationship;
    }

    public void setCharacteristicRelationship(List<CharacteristicRelationshipMVO> characteristicRelationship) {
        this.characteristicRelationship = characteristicRelationship;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacteristicMVO characteristicMVO = (CharacteristicMVO)o;
        return Objects.equals(this.type, characteristicMVO.type) && Objects.equals(this.baseType, characteristicMVO.baseType) && Objects.equals(this.schemaLocation, characteristicMVO.schemaLocation) && Objects.equals(this.uuid, characteristicMVO.uuid) && Objects.equals(this.name, characteristicMVO.name) && Objects.equals(this.valueType, characteristicMVO.valueType) && Objects.equals(this.characteristicRelationship, characteristicMVO.characteristicRelationship);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.uuid, this.name, this.valueType, this.characteristicRelationship);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacteristicMVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    characteristicRelationship: ").append(this.toIndentedString(this.characteristicRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

