/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.CharacteristicRelationshipFVO;

public class CharacteristicFVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="valueType")
    private String valueType;
    @JsonProperty(value="characteristicRelationship")
    @Valid
    private List<CharacteristicRelationshipFVO> characteristicRelationship = new ArrayList<CharacteristicRelationshipFVO>();

    public CharacteristicFVO() {
    }

    public CharacteristicFVO(String type) {
        this.type = type;
    }

    public CharacteristicFVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CharacteristicFVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public CharacteristicFVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public CharacteristicFVO name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Name of the characteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CharacteristicFVO valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(name="valueType", description="Data type of the value of the characteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public CharacteristicFVO characteristicRelationship(List<CharacteristicRelationshipFVO> characteristicRelationship) {
        this.characteristicRelationship = characteristicRelationship;
        return this;
    }

    public CharacteristicFVO addCharacteristicRelationshipItem(CharacteristicRelationshipFVO characteristicRelationshipItem) {
        if (this.characteristicRelationship == null) {
            this.characteristicRelationship = new ArrayList<CharacteristicRelationshipFVO>();
        }
        this.characteristicRelationship.add(characteristicRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="characteristicRelationship", description="Collection of characteristic relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicRelationshipFVO> getCharacteristicRelationship() {
        return this.characteristicRelationship;
    }

    public void setCharacteristicRelationship(List<CharacteristicRelationshipFVO> characteristicRelationship) {
        this.characteristicRelationship = characteristicRelationship;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacteristicFVO characteristicFVO = (CharacteristicFVO)o;
        return Objects.equals(this.type, characteristicFVO.type) && Objects.equals(this.baseType, characteristicFVO.baseType) && Objects.equals(this.schemaLocation, characteristicFVO.schemaLocation) && Objects.equals(this.name, characteristicFVO.name) && Objects.equals(this.valueType, characteristicFVO.valueType) && Objects.equals(this.characteristicRelationship, characteristicFVO.characteristicRelationship);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.name, this.valueType, this.characteristicRelationship);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacteristicFVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    characteristicRelationship: ").append(this.toIndentedString(this.characteristicRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

