/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.pm628.model.CharacteristicRelationship;

@Entity(name="PM628_Characteristic")
public class Characteristic
extends BaseRootNamedEntity {
    @JsonProperty(value="valueType")
    private String valueType;
    @JsonProperty(value="characteristicRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_char_char_rel", joinColumns={@JoinColumn(name="char_uuid")}, inverseJoinColumns={@JoinColumn(name="char_rel_uuid")})
    private List<CharacteristicRelationship> characteristicRelationship = new ArrayList<CharacteristicRelationship>();

    public Characteristic() {
    }

    public Characteristic(String type) {
        this.type = type;
    }

    public Characteristic valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(name="valueType", description="Data type of the value of the characteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public Characteristic characteristicRelationship(List<CharacteristicRelationship> characteristicRelationship) {
        this.characteristicRelationship = characteristicRelationship;
        return this;
    }

    public Characteristic addCharacteristicRelationshipItem(CharacteristicRelationship characteristicRelationshipItem) {
        if (this.characteristicRelationship == null) {
            this.characteristicRelationship = new ArrayList<CharacteristicRelationship>();
        }
        this.characteristicRelationship.add(characteristicRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="characteristicRelationship", description="Collection of characteristic relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicRelationship> getCharacteristicRelationship() {
        return this.characteristicRelationship;
    }

    public void setCharacteristicRelationship(List<CharacteristicRelationship> characteristicRelationship) {
        this.characteristicRelationship = characteristicRelationship;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Characteristic characteristic = (Characteristic)o;
        return Objects.equals(this.type, characteristic.type) && Objects.equals(this.baseType, characteristic.baseType) && Objects.equals(this.schemaLocation, characteristic.schemaLocation) && Objects.equals(this.uuid, characteristic.uuid) && Objects.equals(this.name, characteristic.name) && Objects.equals(this.valueType, characteristic.valueType) && Objects.equals(this.characteristicRelationship, characteristic.characteristicRelationship);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.uuid, this.name, this.valueType, this.characteristicRelationship);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Characteristic {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    characteristicRelationship: ").append(this.toIndentedString(this.characteristicRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

