/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

public class BaseEvent {
    private String atType;
    private String atBaseType;
    private String atSchemaLocation;
    private String href;
    private String id;
    private Object event;
    private String eventId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime eventTime;
    private String eventType;
    private String correlationId;
    private String domain;
    private String title;
    private String description;
    private String priority;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime timeOcurred;

    public BaseEvent() {
    }

    public BaseEvent(String atType) {
        this.atType = atType;
    }

    public BaseEvent atType(String atType) {
        this.atType = atType;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="@type")
    public String getAtType() {
        return this.atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public BaseEvent atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@baseType")
    public String getAtBaseType() {
        return this.atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public BaseEvent atSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@schemaLocation")
    public String getAtSchemaLocation() {
        return this.atSchemaLocation;
    }

    public void setAtSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public BaseEvent href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="href")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public BaseEvent id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BaseEvent event(Object event) {
        this.event = event;
        return this;
    }

    @Schema(name="event", description="The event linked to the involved resource object", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="event")
    public Object getEvent() {
        return this.event;
    }

    public void setEvent(Object event) {
        this.event = event;
    }

    public BaseEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(name="eventId", description="The identifier of the notification.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public BaseEvent eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Valid
    @Schema(name="eventTime", description="Time of the event occurrence.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="eventTime")
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public BaseEvent eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(name="eventType", description="The type of the notification.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="eventType")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public BaseEvent correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Schema(name="correlationId", description="The correlation id for this event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="correlationId")
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public BaseEvent domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(name="domain", description="The domain of the event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public BaseEvent title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="The title of the event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BaseEvent description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="An explanatory of the event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BaseEvent priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(name="priority", description="A priority.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="priority")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public BaseEvent timeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
        return this;
    }

    @Valid
    @Schema(name="timeOcurred", description="The time the event occurred.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="timeOcurred")
    public OffsetDateTime getTimeOcurred() {
        return this.timeOcurred;
    }

    public void setTimeOcurred(OffsetDateTime timeOcurred) {
        this.timeOcurred = timeOcurred;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEvent baseEvent = (BaseEvent)o;
        return Objects.equals(this.atType, baseEvent.atType) && Objects.equals(this.atBaseType, baseEvent.atBaseType) && Objects.equals(this.atSchemaLocation, baseEvent.atSchemaLocation) && Objects.equals(this.href, baseEvent.href) && Objects.equals(this.id, baseEvent.id) && Objects.equals(this.event, baseEvent.event) && Objects.equals(this.eventId, baseEvent.eventId) && Objects.equals(this.eventTime, baseEvent.eventTime) && Objects.equals(this.eventType, baseEvent.eventType) && Objects.equals(this.correlationId, baseEvent.correlationId) && Objects.equals(this.domain, baseEvent.domain) && Objects.equals(this.title, baseEvent.title) && Objects.equals(this.description, baseEvent.description) && Objects.equals(this.priority, baseEvent.priority) && Objects.equals(this.timeOcurred, baseEvent.timeOcurred);
    }

    public int hashCode() {
        return Objects.hash(this.atType, this.atBaseType, this.atSchemaLocation, this.href, this.id, this.event, this.eventId, this.eventTime, this.eventType, this.correlationId, this.domain, this.title, this.description, this.priority, this.timeOcurred);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseEvent {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.atType)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.atSchemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    timeOcurred: ").append(this.toIndentedString(this.timeOcurred)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

