/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.Quantity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Description of a productTerm linked to this product. This represent a commitment with a duration")
@Validated
@Entity(name="ProdTerm637")
public class ProductTerm
extends BaseRootNamedEntity {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="duration")
    private Quantity duration = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public ProductTerm description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the productTerm")
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ProductTerm name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the productTerm")
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ProductTerm duration(Quantity duration) {
        this.duration = duration;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Quantity getDuration() {
        return this.duration;
    }

    public void setDuration(Quantity duration) {
        this.duration = duration;
    }

    public ProductTerm validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductTerm productTerm = (ProductTerm)o;
        return Objects.equals(this.description, productTerm.description) && Objects.equals(this.name, productTerm.name) && Objects.equals(this.duration, productTerm.duration) && Objects.equals(this.validFor, productTerm.validFor) && Objects.equals(this.baseType, productTerm.baseType) && Objects.equals(this.schemaLocation, productTerm.schemaLocation) && Objects.equals(this.type, productTerm.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.name, this.duration, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductTerm {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

