/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import java.util.Objects;
import org.etsi.osl.tmf.pim637.model.ProductStateChangeEventPayload;
import org.springframework.validation.annotation.Validated;

@Schema(description="The notification data structure")
@Validated
public class ProductStateChangeEvent {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="eventId")
    private String eventId = null;
    @JsonProperty(value="eventTime")
    private Date eventTime = null;
    @JsonProperty(value="eventType")
    private String eventType = null;
    @JsonProperty(value="correlationId")
    private String correlationId = null;
    @JsonProperty(value="domain")
    private String domain = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="priority")
    private String priority = null;
    @JsonProperty(value="timeOcurred")
    private Date timeOcurred = null;
    @JsonProperty(value="event")
    private ProductStateChangeEventPayload event = null;

    public ProductStateChangeEvent id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Identifier of the Process flow")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProductStateChangeEvent href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of the ProcessFlow")
    @NotNull
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ProductStateChangeEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(description="The identifier of the notification.")
    @NotNull
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public ProductStateChangeEvent eventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Schema(description="Time of the event occurrence.")
    @NotNull
    @Valid
    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public ProductStateChangeEvent eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(description="The type of the notification.")
    @NotNull
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public ProductStateChangeEvent correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Schema(description="The correlation id for this event.")
    @NotNull
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public ProductStateChangeEvent domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(description="The domain of the event.")
    @NotNull
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ProductStateChangeEvent title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The title of the event.")
    @NotNull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ProductStateChangeEvent description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="An explnatory of the event.")
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProductStateChangeEvent priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A priority.")
    @NotNull
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public ProductStateChangeEvent timeOcurred(Date timeOcurred) {
        this.timeOcurred = timeOcurred;
        return this;
    }

    @Schema(description="The time the event occured.")
    @NotNull
    @Valid
    public Date getTimeOcurred() {
        return this.timeOcurred;
    }

    public void setTimeOcurred(Date timeOcurred) {
        this.timeOcurred = timeOcurred;
    }

    public ProductStateChangeEvent event(ProductStateChangeEventPayload event) {
        this.event = event;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductStateChangeEventPayload getEvent() {
        return this.event;
    }

    public void setEvent(ProductStateChangeEventPayload event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductStateChangeEvent productStateChangeEvent = (ProductStateChangeEvent)o;
        return Objects.equals(this.id, productStateChangeEvent.id) && Objects.equals(this.href, productStateChangeEvent.href) && Objects.equals(this.eventId, productStateChangeEvent.eventId) && Objects.equals(this.eventTime, productStateChangeEvent.eventTime) && Objects.equals(this.eventType, productStateChangeEvent.eventType) && Objects.equals(this.correlationId, productStateChangeEvent.correlationId) && Objects.equals(this.domain, productStateChangeEvent.domain) && Objects.equals(this.title, productStateChangeEvent.title) && Objects.equals(this.description, productStateChangeEvent.description) && Objects.equals(this.priority, productStateChangeEvent.priority) && Objects.equals(this.timeOcurred, productStateChangeEvent.timeOcurred) && Objects.equals(this.event, productStateChangeEvent.event);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.eventId, this.eventTime, this.eventType, this.correlationId, this.domain, this.title, this.description, this.priority, this.timeOcurred, this.event);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductStateChangeEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    timeOcurred: ").append(this.toIndentedString(this.timeOcurred)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

