/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pim637.model.ProductRefOrValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="Linked products to the one instantiate, such as [bundled] if the product is a bundle and you want to describe the bundled products inside this bundle; [reliesOn] if the product needs another already owned product to rely on (e.g. an option on an already owned mobile access product) [targets] or [isTargeted] (depending on the way of expressing the link) for any other kind of links that may be useful")
@Validated
@Entity(name="ProdRel637")
public class ProductRelationship
extends BaseRootEntity {
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="product")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="prod_refuuid", referencedColumnName="uuid")
    private ProductRefOrValue product = null;

    public ProductRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(required=true, description="Type of the product relationship, such as [bundled] if the product is a bundle and you want to describe the bundled products inside this bundle; [reliesOn] if the product needs another already owned product to rely on (e.g. an option on an already owned mobile access product) [targets] or [isTargeted] (depending on the way of expressing the link) for any other kind of links that may be useful")
    @NotNull
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public ProductRelationship product(ProductRefOrValue product) {
        this.product = product;
        return this;
    }

    @Schema(required=true, description="")
    @NotNull
    @Valid
    public ProductRefOrValue getProduct() {
        return this.product;
    }

    public void setProduct(ProductRefOrValue product) {
        this.product = product;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductRelationship productRelationship = (ProductRelationship)o;
        return Objects.equals(this.relationshipType, productRelationship.relationshipType) && Objects.equals(this.product, productRelationship.product) && Objects.equals(this.baseType, productRelationship.baseType) && Objects.equals(this.schemaLocation, productRelationship.schemaLocation) && Objects.equals(this.type, productRelationship.type);
    }

    public int hashCode() {
        return Objects.hash(this.relationshipType, this.product, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductRelationship {\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

