/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.etsi.osl.tmf.pim637.model.Product;
import org.springframework.validation.annotation.Validated;

@Schema(description="A product to be created defined by value or existing defined by reference. The polymorphic attributes @type, @schemaLocation & @referredType are related to the product entity and not the RelatedProductRefOrValue class itself")
@Validated
@Entity(name="ProdRefOrVal637")
@JsonIgnoreProperties(value={"uuid"})
public class ProductRefOrValue
extends Product {
    @Override
    @Schema(description="Unique identifier of the product")
    @NotNull
    public String getId() {
        if (this.id == null) {
            return super.getId();
        }
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Characteristic findCharacteristicByName(String aName) {
        for (Characteristic c : this.productCharacteristic) {
            if (!c.getName().equals(aName)) continue;
            return c;
        }
        return null;
    }

    public Object getRealizingServiceById(@NotNull String id) {
        for (ServiceRef sr : this.realizingService) {
            if (!sr.getId().equals(id)) continue;
            return sr;
        }
        return null;
    }

    public Object getRealizingResourceById(@NotNull String id) {
        for (ResourceRef sr : this.realizingResource) {
            if (!sr.getId().equals(id)) continue;
            return sr;
        }
        return null;
    }
}

