/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPriceRef;
import org.etsi.osl.tmf.pim637.model.BillingAccountRef;
import org.etsi.osl.tmf.pim637.model.Price;
import org.etsi.osl.tmf.pim637.model.PriceAlteration;
import org.springframework.validation.annotation.Validated;

@Schema(description="An amount, usually of money, that represents the actual price paid by a Customer for a purchase, a rent or a lease of a Product. The price is valid for a defined period of time.")
@Validated
@Entity(name="ProdPrice637")
public class ProductPrice
extends BaseRootNamedEntity {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="priceType")
    private String priceType = null;
    @JsonProperty(value="recurringChargePeriod")
    private String recurringChargePeriod = null;
    @JsonProperty(value="unitOfMeasure")
    private String unitOfMeasure = null;
    @JsonProperty(value="billingAccount")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="billing_acc_refuuid", referencedColumnName="uuid")
    private BillingAccountRef billingAccount = null;
    @JsonProperty(value="price")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="price_uuid", referencedColumnName="uuid")
    private Price price = null;
    @JsonProperty(value="productOfferingPrice")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="prodoffprice_refuuid", referencedColumnName="uuid")
    private ProductOfferingPriceRef productOfferingPrice = null;
    @JsonProperty(value="productPriceAlteration")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<PriceAlteration> productPriceAlteration = new HashSet<PriceAlteration>();

    public ProductPrice description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail the semantics of this product price.")
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ProductPrice name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="A short descriptive name such as \"Subscription price\".")
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ProductPrice priceType(String priceType) {
        this.priceType = priceType;
        return this;
    }

    @Schema(required=true, description="A category that describes the price, such as recurring, discount, allowance, penalty, and so forth.")
    @NotNull
    public String getPriceType() {
        return this.priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public ProductPrice recurringChargePeriod(String recurringChargePeriod) {
        this.recurringChargePeriod = recurringChargePeriod;
        return this;
    }

    @Schema(description="Could be month, week...")
    @NotNull
    public String getRecurringChargePeriod() {
        return this.recurringChargePeriod;
    }

    public void setRecurringChargePeriod(String recurringChargePeriod) {
        this.recurringChargePeriod = recurringChargePeriod;
    }

    public ProductPrice unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="Could be minutes, GB...")
    @NotNull
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public ProductPrice billingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public BillingAccountRef getBillingAccount() {
        return this.billingAccount;
    }

    public void setBillingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
    }

    public ProductPrice price(Price price) {
        this.price = price;
        return this;
    }

    @Schema(required=true, description="")
    @NotNull
    @Valid
    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price price) {
        this.price = price;
    }

    public ProductPrice productOfferingPrice(ProductOfferingPriceRef productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductOfferingPriceRef getProductOfferingPrice() {
        return this.productOfferingPrice;
    }

    public void setProductOfferingPrice(ProductOfferingPriceRef productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
    }

    public ProductPrice productPriceAlteration(Set<PriceAlteration> productPriceAlteration) {
        this.productPriceAlteration = productPriceAlteration;
        return this;
    }

    public ProductPrice addProductPriceAlterationItem(PriceAlteration productPriceAlterationItem) {
        if (this.productPriceAlteration == null) {
            this.productPriceAlteration = new HashSet<PriceAlteration>();
        }
        this.productPriceAlteration.add(productPriceAlterationItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<PriceAlteration> getProductPriceAlteration() {
        return this.productPriceAlteration;
    }

    public void setProductPriceAlteration(Set<PriceAlteration> productPriceAlteration) {
        this.productPriceAlteration = productPriceAlteration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductPrice productPrice = (ProductPrice)o;
        return Objects.equals(this.description, productPrice.description) && Objects.equals(this.name, productPrice.name) && Objects.equals(this.priceType, productPrice.priceType) && Objects.equals(this.recurringChargePeriod, productPrice.recurringChargePeriod) && Objects.equals(this.unitOfMeasure, productPrice.unitOfMeasure) && Objects.equals(this.billingAccount, productPrice.billingAccount) && Objects.equals(this.price, productPrice.price) && Objects.equals(this.productOfferingPrice, productPrice.productOfferingPrice) && Objects.equals(this.productPriceAlteration, productPrice.productPriceAlteration) && Objects.equals(this.baseType, productPrice.baseType) && Objects.equals(this.schemaLocation, productPrice.schemaLocation) && Objects.equals(this.baseType, productPrice.baseType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.name, this.priceType, this.recurringChargePeriod, this.unitOfMeasure, this.billingAccount, this.price, this.productOfferingPrice, this.productPriceAlteration, this.baseType, this.schemaLocation, this.baseType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductPrice {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priceType: ").append(this.toIndentedString(this.priceType)).append("\n");
        sb.append("    recurringChargePeriod: ").append(this.toIndentedString(this.recurringChargePeriod)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    billingAccount: ").append(this.toIndentedString(this.billingAccount)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    productOfferingPrice: ").append(this.toIndentedString(this.productOfferingPrice)).append("\n");
        sb.append("    productPriceAlteration: ").append(this.toIndentedString(this.productPriceAlteration)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

