/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingRef;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationRef;
import org.etsi.osl.tmf.pim637.model.BillingAccountRef;
import org.etsi.osl.tmf.pim637.model.ProductPrice;
import org.etsi.osl.tmf.pim637.model.ProductRefOrValue;
import org.etsi.osl.tmf.pim637.model.ProductRelationship;
import org.etsi.osl.tmf.pim637.model.ProductStatusType;
import org.etsi.osl.tmf.pim637.model.ProductTerm;
import org.etsi.osl.tmf.pim637.model.RelatedPlaceRefOrValue;
import org.etsi.osl.tmf.po622.model.AgreementItemRef;
import org.etsi.osl.tmf.po622.model.RelatedProductOrderItem;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="A product offering procured by a customer or other interested party playing a party role. A product is realized as one or more service(s) and / or resource(s). Skipped properties: id,href")
@Validated
public class ProductCreate {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="isBundle")
    private Boolean isBundle = null;
    @JsonProperty(value="isCustomerVisible")
    private Boolean isCustomerVisible = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="orderDate")
    private Date orderDate = null;
    @JsonProperty(value="productSerialNumber")
    private String productSerialNumber = null;
    @JsonProperty(value="startDate")
    private Date startDate = null;
    @JsonProperty(value="terminationDate")
    private Date terminationDate = null;
    @JsonProperty(value="agreement")
    @Valid
    private List<AgreementItemRef> agreement = null;
    @JsonProperty(value="billingAccount")
    private BillingAccountRef billingAccount = null;
    @JsonProperty(value="place")
    @Valid
    private List<RelatedPlaceRefOrValue> place = null;
    @JsonProperty(value="product")
    @Valid
    private List<ProductRefOrValue> product = null;
    @JsonProperty(value="productCharacteristic")
    @Valid
    private List<Characteristic> productCharacteristic = null;
    @JsonProperty(value="productOffering")
    private ProductOfferingRef productOffering = null;
    @JsonProperty(value="productOrderItem")
    @Valid
    private List<RelatedProductOrderItem> productOrderItem = null;
    @JsonProperty(value="productPrice")
    @Valid
    private List<ProductPrice> productPrice = null;
    @JsonProperty(value="productRelationship")
    @Valid
    private List<ProductRelationship> productRelationship = null;
    @JsonProperty(value="productSpecification")
    private ProductSpecificationRef productSpecification = null;
    @JsonProperty(value="productTerm")
    @Valid
    private List<ProductTerm> productTerm = null;
    @JsonProperty(value="realizingResource")
    @Valid
    private List<ResourceRef> realizingResource = null;
    @JsonProperty(value="realizingService")
    @Valid
    private List<ServiceRef> realizingService = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @JsonProperty(value="status")
    private ProductStatusType status = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public ProductCreate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Is the description of the product. It could be copied from the description of the Product Offering.")
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProductCreate isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="If true, the product is a ProductBundle which is an instantiation of a BundledProductOffering. If false, the product is a ProductComponent which is an instantiation of a SimpleProductOffering.")
    @NotNull
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ProductCreate isCustomerVisible(Boolean isCustomerVisible) {
        this.isCustomerVisible = isCustomerVisible;
        return this;
    }

    @Schema(description="If true, the product is visible by the customer.")
    @NotNull
    public Boolean isIsCustomerVisible() {
        return this.isCustomerVisible;
    }

    public void setIsCustomerVisible(Boolean isCustomerVisible) {
        this.isCustomerVisible = isCustomerVisible;
    }

    public ProductCreate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the product. It could be the same as the name of the product offering")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProductCreate orderDate(Date orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Schema(description="Is the date when the product was ordered")
    @NotNull
    @Valid
    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public ProductCreate productSerialNumber(String productSerialNumber) {
        this.productSerialNumber = productSerialNumber;
        return this;
    }

    @Schema(description="Is the serial number for the product. This is typically applicable to tangible products e.g. Broadband Router.")
    @NotNull
    public String getProductSerialNumber() {
        return this.productSerialNumber;
    }

    public void setProductSerialNumber(String productSerialNumber) {
        this.productSerialNumber = productSerialNumber;
    }

    public ProductCreate startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Is the date from which the product starts")
    @NotNull
    @Valid
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public ProductCreate terminationDate(Date terminationDate) {
        this.terminationDate = terminationDate;
        return this;
    }

    @Schema(description="Is the date when the product was terminated")
    @NotNull
    @Valid
    public Date getTerminationDate() {
        return this.terminationDate;
    }

    public void setTerminationDate(Date terminationDate) {
        this.terminationDate = terminationDate;
    }

    public ProductCreate agreement(List<AgreementItemRef> agreement) {
        this.agreement = agreement;
        return this;
    }

    public ProductCreate addAgreementItem(AgreementItemRef agreementItem) {
        if (this.agreement == null) {
            this.agreement = new ArrayList<AgreementItemRef>();
        }
        this.agreement.add(agreementItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<AgreementItemRef> getAgreement() {
        return this.agreement;
    }

    public void setAgreement(List<AgreementItemRef> agreement) {
        this.agreement = agreement;
    }

    public ProductCreate billingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public BillingAccountRef getBillingAccount() {
        return this.billingAccount;
    }

    public void setBillingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
    }

    public ProductCreate place(List<RelatedPlaceRefOrValue> place) {
        this.place = place;
        return this;
    }

    public ProductCreate addPlaceItem(RelatedPlaceRefOrValue placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<RelatedPlaceRefOrValue>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<RelatedPlaceRefOrValue> getPlace() {
        return this.place;
    }

    public void setPlace(List<RelatedPlaceRefOrValue> place) {
        this.place = place;
    }

    public ProductCreate product(List<ProductRefOrValue> product) {
        this.product = product;
        return this;
    }

    public ProductCreate addProductItem(ProductRefOrValue productItem) {
        if (this.product == null) {
            this.product = new ArrayList<ProductRefOrValue>();
        }
        this.product.add(productItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<ProductRefOrValue> getProduct() {
        return this.product;
    }

    public void setProduct(List<ProductRefOrValue> product) {
        this.product = product;
    }

    public ProductCreate productCharacteristic(List<Characteristic> productCharacteristic) {
        this.productCharacteristic = productCharacteristic;
        return this;
    }

    public ProductCreate addProductCharacteristicItem(Characteristic productCharacteristicItem) {
        if (this.productCharacteristic == null) {
            this.productCharacteristic = new ArrayList<Characteristic>();
        }
        this.productCharacteristic.add(productCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<Characteristic> getProductCharacteristic() {
        return this.productCharacteristic;
    }

    public void setProductCharacteristic(List<Characteristic> productCharacteristic) {
        this.productCharacteristic = productCharacteristic;
    }

    public ProductCreate productOffering(ProductOfferingRef productOffering) {
        this.productOffering = productOffering;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductOfferingRef getProductOffering() {
        return this.productOffering;
    }

    public void setProductOffering(ProductOfferingRef productOffering) {
        this.productOffering = productOffering;
    }

    public ProductCreate productOrderItem(List<RelatedProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
        return this;
    }

    public ProductCreate addProductOrderItemItem(RelatedProductOrderItem productOrderItemItem) {
        if (this.productOrderItem == null) {
            this.productOrderItem = new ArrayList<RelatedProductOrderItem>();
        }
        this.productOrderItem.add(productOrderItemItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<RelatedProductOrderItem> getProductOrderItem() {
        return this.productOrderItem;
    }

    public void setProductOrderItem(List<RelatedProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
    }

    public ProductCreate productPrice(List<ProductPrice> productPrice) {
        this.productPrice = productPrice;
        return this;
    }

    public ProductCreate addProductPriceItem(ProductPrice productPriceItem) {
        if (this.productPrice == null) {
            this.productPrice = new ArrayList<ProductPrice>();
        }
        this.productPrice.add(productPriceItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<ProductPrice> getProductPrice() {
        return this.productPrice;
    }

    public void setProductPrice(List<ProductPrice> productPrice) {
        this.productPrice = productPrice;
    }

    public ProductCreate productRelationship(List<ProductRelationship> productRelationship) {
        this.productRelationship = productRelationship;
        return this;
    }

    public ProductCreate addProductRelationshipItem(ProductRelationship productRelationshipItem) {
        if (this.productRelationship == null) {
            this.productRelationship = new ArrayList<ProductRelationship>();
        }
        this.productRelationship.add(productRelationshipItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<ProductRelationship> getProductRelationship() {
        return this.productRelationship;
    }

    public void setProductRelationship(List<ProductRelationship> productRelationship) {
        this.productRelationship = productRelationship;
    }

    public ProductCreate productSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductSpecificationRef getProductSpecification() {
        return this.productSpecification;
    }

    public void setProductSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
    }

    public ProductCreate productTerm(List<ProductTerm> productTerm) {
        this.productTerm = productTerm;
        return this;
    }

    public ProductCreate addProductTermItem(ProductTerm productTermItem) {
        if (this.productTerm == null) {
            this.productTerm = new ArrayList<ProductTerm>();
        }
        this.productTerm.add(productTermItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<ProductTerm> getProductTerm() {
        return this.productTerm;
    }

    public void setProductTerm(List<ProductTerm> productTerm) {
        this.productTerm = productTerm;
    }

    public ProductCreate realizingResource(List<ResourceRef> realizingResource) {
        this.realizingResource = realizingResource;
        return this;
    }

    public ProductCreate addRealizingResourceItem(ResourceRef realizingResourceItem) {
        if (this.realizingResource == null) {
            this.realizingResource = new ArrayList<ResourceRef>();
        }
        this.realizingResource.add(realizingResourceItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<ResourceRef> getRealizingResource() {
        return this.realizingResource;
    }

    public void setRealizingResource(List<ResourceRef> realizingResource) {
        this.realizingResource = realizingResource;
    }

    public ProductCreate realizingService(List<ServiceRef> realizingService) {
        this.realizingService = realizingService;
        return this;
    }

    public ProductCreate addRealizingServiceItem(ServiceRef realizingServiceItem) {
        if (this.realizingService == null) {
            this.realizingService = new ArrayList<ServiceRef>();
        }
        this.realizingService.add(realizingServiceItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<ServiceRef> getRealizingService() {
        return this.realizingService;
    }

    public void setRealizingService(List<ServiceRef> realizingService) {
        this.realizingService = realizingService;
    }

    public ProductCreate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ProductCreate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ProductCreate status(ProductStatusType status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="")
    @NotNull
    @Valid
    public ProductStatusType getStatus() {
        return this.status;
    }

    public void setStatus(ProductStatusType status) {
        this.status = status;
    }

    public ProductCreate _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    @NotNull
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ProductCreate _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    @NotNull
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ProductCreate _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    @NotNull
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductCreate productCreate = (ProductCreate)o;
        return Objects.equals(this.description, productCreate.description) && Objects.equals(this.isBundle, productCreate.isBundle) && Objects.equals(this.isCustomerVisible, productCreate.isCustomerVisible) && Objects.equals(this.name, productCreate.name) && Objects.equals(this.orderDate, productCreate.orderDate) && Objects.equals(this.productSerialNumber, productCreate.productSerialNumber) && Objects.equals(this.startDate, productCreate.startDate) && Objects.equals(this.terminationDate, productCreate.terminationDate) && Objects.equals(this.agreement, productCreate.agreement) && Objects.equals(this.billingAccount, productCreate.billingAccount) && Objects.equals(this.place, productCreate.place) && Objects.equals(this.product, productCreate.product) && Objects.equals(this.productCharacteristic, productCreate.productCharacteristic) && Objects.equals(this.productOffering, productCreate.productOffering) && Objects.equals(this.productOrderItem, productCreate.productOrderItem) && Objects.equals(this.productPrice, productCreate.productPrice) && Objects.equals(this.productRelationship, productCreate.productRelationship) && Objects.equals(this.productSpecification, productCreate.productSpecification) && Objects.equals(this.productTerm, productCreate.productTerm) && Objects.equals(this.realizingResource, productCreate.realizingResource) && Objects.equals(this.realizingService, productCreate.realizingService) && Objects.equals(this.relatedParty, productCreate.relatedParty) && Objects.equals((Object)this.status, (Object)productCreate.status) && Objects.equals(this._atBaseType, productCreate._atBaseType) && Objects.equals(this._atSchemaLocation, productCreate._atSchemaLocation) && Objects.equals(this._atType, productCreate._atType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.isBundle, this.isCustomerVisible, this.name, this.orderDate, this.productSerialNumber, this.startDate, this.terminationDate, this.agreement, this.billingAccount, this.place, this.product, this.productCharacteristic, this.productOffering, this.productOrderItem, this.productPrice, this.productRelationship, this.productSpecification, this.productTerm, this.realizingResource, this.realizingService, this.relatedParty, this.status, this._atBaseType, this._atSchemaLocation, this._atType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductCreate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    isCustomerVisible: ").append(this.toIndentedString(this.isCustomerVisible)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    productSerialNumber: ").append(this.toIndentedString(this.productSerialNumber)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    terminationDate: ").append(this.toIndentedString(this.terminationDate)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    billingAccount: ").append(this.toIndentedString(this.billingAccount)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    productCharacteristic: ").append(this.toIndentedString(this.productCharacteristic)).append("\n");
        sb.append("    productOffering: ").append(this.toIndentedString(this.productOffering)).append("\n");
        sb.append("    productOrderItem: ").append(this.toIndentedString(this.productOrderItem)).append("\n");
        sb.append("    productPrice: ").append(this.toIndentedString(this.productPrice)).append("\n");
        sb.append("    productRelationship: ").append(this.toIndentedString(this.productRelationship)).append("\n");
        sb.append("    productSpecification: ").append(this.toIndentedString(this.productSpecification)).append("\n");
        sb.append("    productTerm: ").append(this.toIndentedString(this.productTerm)).append("\n");
        sb.append("    realizingResource: ").append(this.toIndentedString(this.realizingResource)).append("\n");
        sb.append("    realizingService: ").append(this.toIndentedString(this.realizingService)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

