/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingRef;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationRef;
import org.etsi.osl.tmf.pim637.model.BillingAccountRef;
import org.etsi.osl.tmf.pim637.model.ProductPrice;
import org.etsi.osl.tmf.pim637.model.ProductRefOrValue;
import org.etsi.osl.tmf.pim637.model.ProductRelationship;
import org.etsi.osl.tmf.pim637.model.ProductStatusType;
import org.etsi.osl.tmf.pim637.model.ProductTerm;
import org.etsi.osl.tmf.pim637.model.RelatedPlaceRefOrValue;
import org.etsi.osl.tmf.po622.model.AgreementItemRef;
import org.etsi.osl.tmf.po622.model.RelatedProductOrderItem;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="A product offering procured by a customer or other interested party playing a party role. A product is realized as one or more service(s) and / or resource(s).")
@Validated
@Entity(name="Product637")
public class Product
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="isBundle")
    protected Boolean isBundle = null;
    @JsonProperty(value="isCustomerVisible")
    protected Boolean isCustomerVisible = null;
    @JsonProperty(value="orderDate")
    protected Date orderDate = null;
    @JsonProperty(value="productSerialNumber")
    protected String productSerialNumber = null;
    @JsonProperty(value="startDate")
    protected Date startDate = null;
    @JsonProperty(value="terminationDate")
    protected Date terminationDate = null;
    @JsonProperty(value="agreement")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<AgreementItemRef> agreement = new HashSet<AgreementItemRef>();
    @JsonProperty(value="billingAccount")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="billing_acc_refuuid", referencedColumnName="uuid")
    protected BillingAccountRef billingAccount = null;
    @JsonProperty(value="place")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<RelatedPlaceRefOrValue> place = new HashSet<RelatedPlaceRefOrValue>();
    @JsonProperty(value="product")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ProductRefOrValue> product = new HashSet<ProductRefOrValue>();
    @JsonProperty(value="productCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<Characteristic> productCharacteristic = new HashSet<Characteristic>();
    @JsonProperty(value="productOffering")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="prodoff_refuuid", referencedColumnName="uuid")
    protected ProductOfferingRef productOffering = null;
    @JsonProperty(value="productOrderItem")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<RelatedProductOrderItem> productOrderItem = new HashSet<RelatedProductOrderItem>();
    @JsonProperty(value="productPrice")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ProductPrice> productPrice = new HashSet<ProductPrice>();
    @JsonProperty(value="productRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ProductRelationship> productRelationship = new HashSet<ProductRelationship>();
    @JsonProperty(value="productSpecification")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="prodspec_refuuid", referencedColumnName="uuid")
    protected ProductSpecificationRef productSpecification = null;
    @JsonProperty(value="productTerm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ProductTerm> productTerm = new HashSet<ProductTerm>();
    @JsonProperty(value="realizingResource")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ResourceRef> realizingResource = new HashSet<ResourceRef>();
    @JsonProperty(value="realizingService")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ServiceRef> realizingService = new HashSet<ServiceRef>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="status")
    protected ProductStatusType status = null;

    public Product id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the product")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Product href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Reference of the product")
    @NotNull
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public Product description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Is the description of the product. It could be copied from the description of the Product Offering.")
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Product isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="If true, the product is a ProductBundle which is an instantiation of a BundledProductOffering. If false, the product is a ProductComponent which is an instantiation of a SimpleProductOffering.")
    @NotNull
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public Product isCustomerVisible(Boolean isCustomerVisible) {
        this.isCustomerVisible = isCustomerVisible;
        return this;
    }

    @Schema(description="If true, the product is visible by the customer.")
    @NotNull
    public Boolean isIsCustomerVisible() {
        return this.isCustomerVisible;
    }

    public void setIsCustomerVisible(Boolean isCustomerVisible) {
        this.isCustomerVisible = isCustomerVisible;
    }

    @Override
    public Product name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the product. It could be the same as the name of the product offering")
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Product orderDate(Date orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Schema(description="Is the date when the product was ordered")
    @NotNull
    @Valid
    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public Product productSerialNumber(String productSerialNumber) {
        this.productSerialNumber = productSerialNumber;
        return this;
    }

    @Schema(description="Is the serial number for the product. This is typically applicable to tangible products e.g. Broadband Router.")
    @NotNull
    public String getProductSerialNumber() {
        return this.productSerialNumber;
    }

    public void setProductSerialNumber(String productSerialNumber) {
        this.productSerialNumber = productSerialNumber;
    }

    public Product startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Is the date from which the product starts")
    @NotNull
    @Valid
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Product terminationDate(Date terminationDate) {
        this.terminationDate = terminationDate;
        return this;
    }

    @Schema(description="Is the date when the product was terminated")
    @NotNull
    @Valid
    public Date getTerminationDate() {
        return this.terminationDate;
    }

    public void setTerminationDate(Date terminationDate) {
        this.terminationDate = terminationDate;
    }

    public Product agreement(Set<AgreementItemRef> agreement) {
        this.agreement = agreement;
        return this;
    }

    public Product addAgreementItem(AgreementItemRef agreementItem) {
        if (this.agreement == null) {
            this.agreement = new HashSet<AgreementItemRef>();
        }
        this.agreement.add(agreementItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<AgreementItemRef> getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Set<AgreementItemRef> agreement) {
        this.agreement = agreement;
    }

    public Product billingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public BillingAccountRef getBillingAccount() {
        return this.billingAccount;
    }

    public void setBillingAccount(BillingAccountRef billingAccount) {
        this.billingAccount = billingAccount;
    }

    public Product place(Set<RelatedPlaceRefOrValue> place) {
        this.place = place;
        return this;
    }

    public Product addPlaceItem(RelatedPlaceRefOrValue placeItem) {
        if (this.place == null) {
            this.place = new HashSet<RelatedPlaceRefOrValue>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<RelatedPlaceRefOrValue> getPlace() {
        return this.place;
    }

    public void setPlace(Set<RelatedPlaceRefOrValue> place) {
        this.place = place;
    }

    public Product product(Set<ProductRefOrValue> product) {
        this.product = product;
        return this;
    }

    public Product addProductItem(ProductRefOrValue productItem) {
        if (this.product == null) {
            this.product = new HashSet<ProductRefOrValue>();
        }
        this.product.add(productItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<ProductRefOrValue> getProduct() {
        return this.product;
    }

    public void setProduct(Set<ProductRefOrValue> product) {
        this.product = product;
    }

    public Product productCharacteristic(Set<Characteristic> productCharacteristic) {
        this.productCharacteristic = productCharacteristic;
        return this;
    }

    public Product addProductCharacteristicItem(Characteristic productCharacteristicItem) {
        if (this.productCharacteristic == null) {
            this.productCharacteristic = new HashSet<Characteristic>();
        }
        this.productCharacteristic.add(productCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<Characteristic> getProductCharacteristic() {
        return this.productCharacteristic;
    }

    public void setProductCharacteristic(Set<Characteristic> productCharacteristic) {
        this.productCharacteristic = productCharacteristic;
    }

    public Product productOffering(ProductOfferingRef productOffering) {
        this.productOffering = productOffering;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductOfferingRef getProductOffering() {
        return this.productOffering;
    }

    public void setProductOffering(ProductOfferingRef productOffering) {
        this.productOffering = productOffering;
    }

    public Product productOrderItem(Set<RelatedProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
        return this;
    }

    public Product addProductOrderItemItem(RelatedProductOrderItem productOrderItemItem) {
        if (this.productOrderItem == null) {
            this.productOrderItem = new HashSet<RelatedProductOrderItem>();
        }
        this.productOrderItem.add(productOrderItemItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<RelatedProductOrderItem> getProductOrderItem() {
        return this.productOrderItem;
    }

    public void setProductOrderItem(Set<RelatedProductOrderItem> productOrderItem) {
        this.productOrderItem = productOrderItem;
    }

    public Product productPrice(Set<ProductPrice> productPrice) {
        this.productPrice = productPrice;
        return this;
    }

    public Product addProductPriceItem(ProductPrice productPriceItem) {
        if (this.productPrice == null) {
            this.productPrice = new HashSet<ProductPrice>();
        }
        this.productPrice.add(productPriceItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<ProductPrice> getProductPrice() {
        return this.productPrice;
    }

    public void setProductPrice(Set<ProductPrice> productPrice) {
        this.productPrice = productPrice;
    }

    public Product productRelationship(Set<ProductRelationship> productRelationship) {
        this.productRelationship = productRelationship;
        return this;
    }

    public Product addProductRelationshipItem(ProductRelationship productRelationshipItem) {
        if (this.productRelationship == null) {
            this.productRelationship = new HashSet<ProductRelationship>();
        }
        this.productRelationship.add(productRelationshipItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<ProductRelationship> getProductRelationship() {
        return this.productRelationship;
    }

    public void setProductRelationship(Set<ProductRelationship> productRelationship) {
        this.productRelationship = productRelationship;
    }

    public Product productSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductSpecificationRef getProductSpecification() {
        return this.productSpecification;
    }

    public void setProductSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
    }

    public Product productTerm(Set<ProductTerm> productTerm) {
        this.productTerm = productTerm;
        return this;
    }

    public Product addProductTermItem(ProductTerm productTermItem) {
        if (this.productTerm == null) {
            this.productTerm = new HashSet<ProductTerm>();
        }
        this.productTerm.add(productTermItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<ProductTerm> getProductTerm() {
        return this.productTerm;
    }

    public void setProductTerm(Set<ProductTerm> productTerm) {
        this.productTerm = productTerm;
    }

    public Product realizingResource(Set<ResourceRef> realizingResource) {
        this.realizingResource = realizingResource;
        return this;
    }

    public Product addRealizingResourceItem(ResourceRef realizingResourceItem) {
        if (this.realizingResource == null) {
            this.realizingResource = new HashSet<ResourceRef>();
        }
        this.realizingResource.add(realizingResourceItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<ResourceRef> getRealizingResource() {
        return this.realizingResource;
    }

    public void setRealizingResource(Set<ResourceRef> realizingResource) {
        this.realizingResource = realizingResource;
    }

    public Product realizingService(Set<ServiceRef> realizingService) {
        this.realizingService = realizingService;
        return this;
    }

    public Product addRealizingServiceItem(ServiceRef realizingServiceItem) {
        if (this.realizingService == null) {
            this.realizingService = new HashSet<ServiceRef>();
        }
        this.realizingService.add(realizingServiceItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<ServiceRef> getRealizingService() {
        return this.realizingService;
    }

    public void setRealizingService(Set<ServiceRef> realizingService) {
        this.realizingService = realizingService;
    }

    public Product relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Product addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Product status(ProductStatusType status) {
        this.status = status;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductStatusType getStatus() {
        return this.status;
    }

    public void setStatus(ProductStatusType status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return Objects.equals(this.id, product.id) && Objects.equals(this.href, product.href) && Objects.equals(this.description, product.description) && Objects.equals(this.isBundle, product.isBundle) && Objects.equals(this.isCustomerVisible, product.isCustomerVisible) && Objects.equals(this.name, product.name) && Objects.equals(this.orderDate, product.orderDate) && Objects.equals(this.productSerialNumber, product.productSerialNumber) && Objects.equals(this.startDate, product.startDate) && Objects.equals(this.terminationDate, product.terminationDate) && Objects.equals(this.agreement, product.agreement) && Objects.equals(this.billingAccount, product.billingAccount) && Objects.equals(this.place, product.place) && Objects.equals(this.product, product.product) && Objects.equals(this.productCharacteristic, product.productCharacteristic) && Objects.equals(this.productOffering, product.productOffering) && Objects.equals(this.productOrderItem, product.productOrderItem) && Objects.equals(this.productPrice, product.productPrice) && Objects.equals(this.productRelationship, product.productRelationship) && Objects.equals(this.productSpecification, product.productSpecification) && Objects.equals(this.productTerm, product.productTerm) && Objects.equals(this.realizingResource, product.realizingResource) && Objects.equals(this.realizingService, product.realizingService) && Objects.equals(this.relatedParty, product.relatedParty) && Objects.equals((Object)this.status, (Object)product.status) && Objects.equals(this.baseType, product.baseType) && Objects.equals(this.schemaLocation, product.schemaLocation) && Objects.equals(this.type, product.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Product {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    isCustomerVisible: ").append(this.toIndentedString(this.isCustomerVisible)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    productSerialNumber: ").append(this.toIndentedString(this.productSerialNumber)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    terminationDate: ").append(this.toIndentedString(this.terminationDate)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    billingAccount: ").append(this.toIndentedString(this.billingAccount)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    productCharacteristic: ").append(this.toIndentedString(this.productCharacteristic)).append("\n");
        sb.append("    productOffering: ").append(this.toIndentedString(this.productOffering)).append("\n");
        sb.append("    productOrderItem: ").append(this.toIndentedString(this.productOrderItem)).append("\n");
        sb.append("    productPrice: ").append(this.toIndentedString(this.productPrice)).append("\n");
        sb.append("    productRelationship: ").append(this.toIndentedString(this.productRelationship)).append("\n");
        sb.append("    productSpecification: ").append(this.toIndentedString(this.productSpecification)).append("\n");
        sb.append("    productTerm: ").append(this.toIndentedString(this.productTerm)).append("\n");
        sb.append("    realizingResource: ").append(this.toIndentedString(this.realizingResource)).append("\n");
        sb.append("    realizingService: ").append(this.toIndentedString(this.realizingService)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

