/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPriceRef;
import org.etsi.osl.tmf.pim637.model.Price;
import org.springframework.validation.annotation.Validated;

@Schema(description="Is an amount, usually of money, that modifies the price charged for an order item.")
@Validated
@Entity(name="PriceAlter637")
public class PriceAlteration
extends BaseRootNamedEntity {
    @JsonProperty(value="applicationDuration")
    private Integer applicationDuration = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="priceType")
    private String priceType = null;
    @JsonProperty(value="priority")
    private Integer priority = null;
    @JsonProperty(value="recurringChargePeriod")
    private String recurringChargePeriod = null;
    @JsonProperty(value="unitOfMeasure")
    private String unitOfMeasure = null;
    @JsonProperty(value="price")
    @OneToOne(cascade={CascadeType.ALL})
    private Price price = null;
    @JsonProperty(value="productOfferingPrice")
    @OneToOne(cascade={CascadeType.ALL})
    private ProductOfferingPriceRef productOfferingPrice = null;

    public PriceAlteration applicationDuration(Integer applicationDuration) {
        this.applicationDuration = applicationDuration;
        return this;
    }

    @Schema(description="Duration during which the alteration applies on the order item price (for instance 2 months free of charge for the recurring charge)")
    @NotNull
    public Integer getApplicationDuration() {
        return this.applicationDuration;
    }

    public void setApplicationDuration(Integer applicationDuration) {
        this.applicationDuration = applicationDuration;
    }

    public PriceAlteration description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail the semantics of this order item price alteration")
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public PriceAlteration name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the order item price alteration")
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public PriceAlteration priceType(String priceType) {
        this.priceType = priceType;
        return this;
    }

    @Schema(required=true, description="A category that describes the price such as recurring, one time and usage.")
    @NotNull
    public String getPriceType() {
        return this.priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public PriceAlteration priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="Priority level for applying this alteration among all the defined alterations on the order item price")
    @NotNull
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public PriceAlteration recurringChargePeriod(String recurringChargePeriod) {
        this.recurringChargePeriod = recurringChargePeriod;
        return this;
    }

    @Schema(description="Could be month, week...")
    @NotNull
    public String getRecurringChargePeriod() {
        return this.recurringChargePeriod;
    }

    public void setRecurringChargePeriod(String recurringChargePeriod) {
        this.recurringChargePeriod = recurringChargePeriod;
    }

    public PriceAlteration unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="Could be minutes, GB...")
    @NotNull
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public PriceAlteration price(Price price) {
        this.price = price;
        return this;
    }

    @Schema(required=true, description="")
    @NotNull
    @Valid
    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price price) {
        this.price = price;
    }

    public PriceAlteration productOfferingPrice(ProductOfferingPriceRef productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ProductOfferingPriceRef getProductOfferingPrice() {
        return this.productOfferingPrice;
    }

    public void setProductOfferingPrice(ProductOfferingPriceRef productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceAlteration priceAlteration = (PriceAlteration)o;
        return Objects.equals(this.applicationDuration, priceAlteration.applicationDuration) && Objects.equals(this.description, priceAlteration.description) && Objects.equals(this.name, priceAlteration.name) && Objects.equals(this.priceType, priceAlteration.priceType) && Objects.equals(this.priority, priceAlteration.priority) && Objects.equals(this.recurringChargePeriod, priceAlteration.recurringChargePeriod) && Objects.equals(this.unitOfMeasure, priceAlteration.unitOfMeasure) && Objects.equals(this.price, priceAlteration.price) && Objects.equals(this.productOfferingPrice, priceAlteration.productOfferingPrice) && Objects.equals(this.baseType, priceAlteration.baseType) && Objects.equals(this.schemaLocation, priceAlteration.schemaLocation) && Objects.equals(this.type, priceAlteration.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.applicationDuration, this.description, this.name, this.priceType, this.priority, this.recurringChargePeriod, this.unitOfMeasure, this.price, this.productOfferingPrice, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PriceAlteration {\n");
        sb.append("    applicationDuration: ").append(this.toIndentedString(this.applicationDuration)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priceType: ").append(this.toIndentedString(this.priceType)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    recurringChargePeriod: ").append(this.toIndentedString(this.recurringChargePeriod)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    productOfferingPrice: ").append(this.toIndentedString(this.productOfferingPrice)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

