/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pim637.model.Money;
import org.springframework.validation.annotation.Validated;

@Schema(description="Provides all amounts (tax included, duty free, tax rate), used currency and percentage to apply for Price Alteration.")
@Validated
@Entity(name="Price637")
public class Price
extends BaseRootEntity {
    @JsonProperty(value="percentage")
    private Float percentage = null;
    @JsonProperty(value="taxRate")
    private Float taxRate = null;
    @JsonProperty(value="dutyFreeAmount")
    @OneToOne(cascade={CascadeType.ALL})
    private Money dutyFreeAmount = null;
    @JsonProperty(value="taxIncludedAmount")
    @OneToOne(cascade={CascadeType.ALL})
    private Money taxIncludedAmount = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public Price percentage(Float percentage) {
        this.percentage = percentage;
        return this;
    }

    @Schema(description="Percentage to apply for ProdOfferPriceAlteration")
    @NotNull
    public Float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Float percentage) {
        this.percentage = percentage;
    }

    public Price taxRate(Float taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @Schema(description="Tax rate")
    @NotNull
    public Float getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(Float taxRate) {
        this.taxRate = taxRate;
    }

    public Price dutyFreeAmount(Money dutyFreeAmount) {
        this.dutyFreeAmount = dutyFreeAmount;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Money getDutyFreeAmount() {
        return this.dutyFreeAmount;
    }

    public void setDutyFreeAmount(Money dutyFreeAmount) {
        this.dutyFreeAmount = dutyFreeAmount;
    }

    public Price taxIncludedAmount(Money taxIncludedAmount) {
        this.taxIncludedAmount = taxIncludedAmount;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Money getTaxIncludedAmount() {
        return this.taxIncludedAmount;
    }

    public void setTaxIncludedAmount(Money taxIncludedAmount) {
        this.taxIncludedAmount = taxIncludedAmount;
    }

    public Price _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    @NotNull
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public Price _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    @NotNull
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public Price _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    @NotNull
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Price price = (Price)o;
        return Objects.equals(this.percentage, price.percentage) && Objects.equals(this.taxRate, price.taxRate) && Objects.equals(this.dutyFreeAmount, price.dutyFreeAmount) && Objects.equals(this.taxIncludedAmount, price.taxIncludedAmount) && Objects.equals(this._atBaseType, price._atBaseType) && Objects.equals(this._atSchemaLocation, price._atSchemaLocation) && Objects.equals(this._atType, price._atType);
    }

    public int hashCode() {
        return Objects.hash(this.percentage, this.taxRate, this.dutyFreeAmount, this.taxIncludedAmount, this._atBaseType, this._atSchemaLocation, this._atType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Price {\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    dutyFreeAmount: ").append(this.toIndentedString(this.dutyFreeAmount)).append("\n");
        sb.append("    taxIncludedAmount: ").append(this.toIndentedString(this.taxIncludedAmount)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

