/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pim637.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="A base / value business entity used to represent money")
@Validated
@Entity(name="Money637")
public class Money
extends BaseRootEntity {
    @JsonProperty(value="unit")
    private String unit = null;
    @JsonProperty(value="value")
    private Float value = null;

    public Money unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Schema(description="Currency (ISO4217 norm uses 3 letters to define the currency)")
    @NotNull
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Money value(Float value) {
        this.value = value;
        return this;
    }

    @Schema(description="A positive floating point number")
    @NotNull
    public Float getValue() {
        return this.value;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Money money = (Money)o;
        return Objects.equals(this.unit, money.unit) && Objects.equals(this.value, money.value);
    }

    public int hashCode() {
        return Objects.hash(this.unit, this.value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Money {\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

