/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pcm620.model.Money;
import org.springframework.validation.annotation.Validated;

@Schema(description="A tax item is created for each tax rate and tax type used in the bill.")
@Validated
@Entity
public class TaxItem
extends BaseRootEntity {
    @JsonProperty(value="taxCategory")
    private String taxCategory = null;
    @JsonProperty(value="taxRate")
    private Float taxRate = null;
    @JsonProperty(value="taxAmount")
    private Money taxAmount = null;

    public TaxItem taxCategory(String taxCategory) {
        this.taxCategory = taxCategory;
        return this;
    }

    @Schema(description="Tax category")
    public String getTaxCategory() {
        return this.taxCategory;
    }

    public void setTaxCategory(String taxCategory) {
        this.taxCategory = taxCategory;
    }

    public TaxItem taxRate(Float taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @Schema(description="Applied rate of the tax")
    public Float getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(Float taxRate) {
        this.taxRate = taxRate;
    }

    public TaxItem taxAmount(Money taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @Schema(description="Amount of tax expressed in the given currency")
    @Valid
    public Money getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Money taxAmount) {
        this.taxAmount = taxAmount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxItem taxItem = (TaxItem)o;
        return Objects.equals(this.taxCategory, taxItem.taxCategory) && Objects.equals(this.taxRate, taxItem.taxRate) && Objects.equals(this.taxAmount, taxItem.taxAmount) && Objects.equals(this.baseType, taxItem.baseType) && Objects.equals(this.schemaLocation, taxItem.schemaLocation) && Objects.equals(this.type, taxItem.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxItem {\n");
        sb.append("    taxCategory: ").append(this.toIndentedString(this.taxCategory)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

