/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.pcm620.model.BundledProductSpecification;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationCharacteristic;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationRelationship;
import org.etsi.osl.tmf.pcm620.model.TargetProductSchema;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Is a detailed description of a tangible or intangible object made available externally in the form of a ProductOffering to customers or other parties playing a party role. Skipped properties: id,href,lastUpdate")
@Validated
public class ProductSpecificationUpdate {
    @JsonProperty(value="brand")
    protected String brand = null;
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="isBundle")
    protected Boolean isBundle = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="productNumber")
    protected String productNumber = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="attachment")
    @Valid
    protected List<AttachmentRefOrValue> attachment = null;
    @JsonProperty(value="bundledProductSpecification")
    @Valid
    protected List<BundledProductSpecification> bundledProductSpecification = null;
    @JsonProperty(value="productSpecCharacteristic")
    @Valid
    protected List<ProductSpecificationCharacteristic> productSpecCharacteristic = null;
    @JsonProperty(value="productSpecificationRelationship")
    @Valid
    protected List<ProductSpecificationRelationship> productSpecificationRelationship = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="resourceSpecification")
    @Valid
    protected List<ResourceSpecificationRef> resourceSpecification = null;
    @JsonProperty(value="serviceSpecification")
    @Valid
    protected List<ServiceSpecificationRef> serviceSpecification = null;
    @JsonProperty(value="targetProductSchema")
    protected TargetProductSchema targetProductSchema = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ProductSpecificationUpdate brand(String brand) {
        this.brand = brand;
        return this;
    }

    @Schema(description="The manufacturer or trademark of the specification")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public ProductSpecificationUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail what the product specification is")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProductSpecificationUpdate isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="isBundle determines whether a productSpecification represents a single productSpecification (false), or a bundle of productSpecification (true).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ProductSpecificationUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ProductSpecificationUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the product specification")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProductSpecificationUpdate productNumber(String productNumber) {
        this.productNumber = productNumber;
        return this;
    }

    @Schema(description="An identification number assigned to uniquely identity the specification")
    public String getProductNumber() {
        return this.productNumber;
    }

    public void setProductNumber(String productNumber) {
        this.productNumber = productNumber;
    }

    public ProductSpecificationUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Product specification version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ProductSpecificationUpdate attachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ProductSpecificationUpdate addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="Complements the description of an element (for instance a product) through video, pictures...")
    @Valid
    public List<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public ProductSpecificationUpdate bundledProductSpecification(List<BundledProductSpecification> bundledProductSpecification) {
        this.bundledProductSpecification = bundledProductSpecification;
        return this;
    }

    public ProductSpecificationUpdate addBundledProductSpecificationItem(BundledProductSpecification bundledProductSpecificationItem) {
        if (this.bundledProductSpecification == null) {
            this.bundledProductSpecification = new ArrayList<BundledProductSpecification>();
        }
        this.bundledProductSpecification.add(bundledProductSpecificationItem);
        return this;
    }

    @Schema(description="A type of ProductSpecification that belongs to a grouping of ProductSpecifications made available to the market. It inherits of all attributes of ProductSpecification.")
    @Valid
    public List<BundledProductSpecification> getBundledProductSpecification() {
        return this.bundledProductSpecification;
    }

    public void setBundledProductSpecification(List<BundledProductSpecification> bundledProductSpecification) {
        this.bundledProductSpecification = bundledProductSpecification;
    }

    public ProductSpecificationUpdate productSpecCharacteristic(List<ProductSpecificationCharacteristic> productSpecCharacteristic) {
        this.productSpecCharacteristic = productSpecCharacteristic;
        return this;
    }

    public ProductSpecificationUpdate addProductSpecCharacteristicItem(ProductSpecificationCharacteristic productSpecCharacteristicItem) {
        if (this.productSpecCharacteristic == null) {
            this.productSpecCharacteristic = new ArrayList<ProductSpecificationCharacteristic>();
        }
        this.productSpecCharacteristic.add(productSpecCharacteristicItem);
        return this;
    }

    @Schema(description="A characteristic quality or distinctive feature of a ProductSpecification.  The characteristic can be take on a discrete value, such as color, can take on a range of values, (for example, sensitivity of 100-240 mV), or can be derived from a formula (for example, usage time (hrs) = 30 - talk time *3). Certain characteristics, such as color, may be configured during the ordering or some other process.")
    @Valid
    public List<ProductSpecificationCharacteristic> getProductSpecCharacteristic() {
        return this.productSpecCharacteristic;
    }

    public void setProductSpecCharacteristic(List<ProductSpecificationCharacteristic> productSpecCharacteristic) {
        this.productSpecCharacteristic = productSpecCharacteristic;
    }

    public ProductSpecificationUpdate productSpecificationRelationship(List<ProductSpecificationRelationship> productSpecificationRelationship) {
        this.productSpecificationRelationship = productSpecificationRelationship;
        return this;
    }

    public ProductSpecificationUpdate addProductSpecificationRelationshipItem(ProductSpecificationRelationship productSpecificationRelationshipItem) {
        if (this.productSpecificationRelationship == null) {
            this.productSpecificationRelationship = new ArrayList<ProductSpecificationRelationship>();
        }
        this.productSpecificationRelationship.add(productSpecificationRelationshipItem);
        return this;
    }

    @Schema(description="A migration, substitution, dependency or exclusivity relationship between/among product specifications.")
    @Valid
    public List<ProductSpecificationRelationship> getProductSpecificationRelationship() {
        return this.productSpecificationRelationship;
    }

    public void setProductSpecificationRelationship(List<ProductSpecificationRelationship> productSpecificationRelationship) {
        this.productSpecificationRelationship = productSpecificationRelationship;
    }

    public ProductSpecificationUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ProductSpecificationUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A related party defines party or party role linked to a specific entity.")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ProductSpecificationUpdate resourceSpecification(List<ResourceSpecificationRef> resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    public ProductSpecificationUpdate addResourceSpecificationItem(ResourceSpecificationRef resourceSpecificationItem) {
        if (this.resourceSpecification == null) {
            this.resourceSpecification = new ArrayList<ResourceSpecificationRef>();
        }
        this.resourceSpecification.add(resourceSpecificationItem);
        return this;
    }

    @Schema(description="The ResourceSpecification is required to realize a ProductSpecification.")
    @Valid
    public List<ResourceSpecificationRef> getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(List<ResourceSpecificationRef> resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public ProductSpecificationUpdate serviceSpecification(List<ServiceSpecificationRef> serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
        return this;
    }

    public ProductSpecificationUpdate addServiceSpecificationItem(ServiceSpecificationRef serviceSpecificationItem) {
        if (this.serviceSpecification == null) {
            this.serviceSpecification = new ArrayList<ServiceSpecificationRef>();
        }
        this.serviceSpecification.add(serviceSpecificationItem);
        return this;
    }

    @Schema(description="ServiceSpecification(s) required to realize a ProductSpecification.")
    @Valid
    public List<ServiceSpecificationRef> getServiceSpecification() {
        return this.serviceSpecification;
    }

    public void setServiceSpecification(List<ServiceSpecificationRef> serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
    }

    public ProductSpecificationUpdate targetProductSchema(TargetProductSchema targetProductSchema) {
        this.targetProductSchema = targetProductSchema;
        return this;
    }

    @Schema(description="A target product schema reference. The reference object to the schema and type of target product which is described by product specification.")
    @Valid
    public TargetProductSchema getTargetProductSchema() {
        return this.targetProductSchema;
    }

    public void setTargetProductSchema(TargetProductSchema targetProductSchema) {
        this.targetProductSchema = targetProductSchema;
    }

    public ProductSpecificationUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the product specification is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ProductSpecificationUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ProductSpecificationUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ProductSpecificationUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductSpecificationUpdate productSpecificationUpdate = (ProductSpecificationUpdate)o;
        return Objects.equals(this.brand, productSpecificationUpdate.brand) && Objects.equals(this.description, productSpecificationUpdate.description) && Objects.equals(this.isBundle, productSpecificationUpdate.isBundle) && Objects.equals(this.lifecycleStatus, productSpecificationUpdate.lifecycleStatus) && Objects.equals(this.name, productSpecificationUpdate.name) && Objects.equals(this.productNumber, productSpecificationUpdate.productNumber) && Objects.equals(this.version, productSpecificationUpdate.version) && Objects.equals(this.attachment, productSpecificationUpdate.attachment) && Objects.equals(this.bundledProductSpecification, productSpecificationUpdate.bundledProductSpecification) && Objects.equals(this.productSpecCharacteristic, productSpecificationUpdate.productSpecCharacteristic) && Objects.equals(this.productSpecificationRelationship, productSpecificationUpdate.productSpecificationRelationship) && Objects.equals(this.relatedParty, productSpecificationUpdate.relatedParty) && Objects.equals(this.resourceSpecification, productSpecificationUpdate.resourceSpecification) && Objects.equals(this.serviceSpecification, productSpecificationUpdate.serviceSpecification) && Objects.equals(this.targetProductSchema, productSpecificationUpdate.targetProductSchema) && Objects.equals(this.validFor, productSpecificationUpdate.validFor) && Objects.equals(this.baseType, productSpecificationUpdate.baseType) && Objects.equals(this.schemaLocation, productSpecificationUpdate.schemaLocation) && Objects.equals(this.type, productSpecificationUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.description, this.isBundle, this.lifecycleStatus, this.name, this.productNumber, this.version, this.attachment, this.bundledProductSpecification, this.productSpecCharacteristic, this.productSpecificationRelationship, this.relatedParty, this.resourceSpecification, this.serviceSpecification, this.targetProductSchema, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductSpecificationUpdate {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    productNumber: ").append(this.toIndentedString(this.productNumber)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    bundledProductSpecification: ").append(this.toIndentedString(this.bundledProductSpecification)).append("\n");
        sb.append("    productSpecCharacteristic: ").append(this.toIndentedString(this.productSpecCharacteristic)).append("\n");
        sb.append("    productSpecificationRelationship: ").append(this.toIndentedString(this.productSpecificationRelationship)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    serviceSpecification: ").append(this.toIndentedString(this.serviceSpecification)).append("\n");
        sb.append("    targetProductSchema: ").append(this.toIndentedString(this.targetProductSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

