/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.pcm620.model.TargetProductSchema;
import org.springframework.validation.annotation.Validated;

@Schema(description="Product specification reference: A ProductSpecification is a detailed description of a tangible or intangible object made available externally in the form of a ProductOffering to customers or other parties playing a party role.")
@Validated
@Entity(name="ProductSpecificationRef")
public class ProductSpecificationRef
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="targetProductSchema")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinColumn(referencedColumnName="uuid")
    private TargetProductSchema targetProductSchema = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    @Schema(description="Unique identifier of a related entity.")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public ProductSpecificationRef schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Override
    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ProductSpecificationRef type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public ProductSpecificationRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductSpecificationRef productSpecificationRef = (ProductSpecificationRef)o;
        return Objects.equals(this.id, productSpecificationRef.id) && Objects.equals(this.href, productSpecificationRef.href) && Objects.equals(this.name, productSpecificationRef.name) && Objects.equals(this.version, productSpecificationRef.version) && Objects.equals(this.targetProductSchema, productSpecificationRef.targetProductSchema) && Objects.equals(this.baseType, productSpecificationRef.baseType) && Objects.equals(this.schemaLocation, productSpecificationRef.schemaLocation) && Objects.equals(this.type, productSpecificationRef.type) && Objects.equals(this.referredType, productSpecificationRef.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductSpecificationRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    targetProductSchema: ").append(this.toIndentedString(this.targetProductSchema)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

