/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="Is a detailed description of a tangible or intangible object made available externally in the form of a ProductOffering to customers or other parties playing a party role. Skipped properties: id,href")
@Validated
public class ProductSpecificationCreate
extends ProductSpecificationUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    public ProductSpecificationCreate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductSpecificationCreate productSpecificationCreate = (ProductSpecificationCreate)o;
        return Objects.equals(this.brand, productSpecificationCreate.brand) && Objects.equals(this.description, productSpecificationCreate.description) && Objects.equals(this.isBundle, productSpecificationCreate.isBundle) && Objects.equals(this.lastUpdate, productSpecificationCreate.lastUpdate) && Objects.equals(this.lifecycleStatus, productSpecificationCreate.lifecycleStatus) && Objects.equals(this.name, productSpecificationCreate.name) && Objects.equals(this.productNumber, productSpecificationCreate.productNumber) && Objects.equals(this.version, productSpecificationCreate.version) && Objects.equals(this.attachment, productSpecificationCreate.attachment) && Objects.equals(this.bundledProductSpecification, productSpecificationCreate.bundledProductSpecification) && Objects.equals(this.productSpecCharacteristic, productSpecificationCreate.productSpecCharacteristic) && Objects.equals(this.productSpecificationRelationship, productSpecificationCreate.productSpecificationRelationship) && Objects.equals(this.relatedParty, productSpecificationCreate.relatedParty) && Objects.equals(this.resourceSpecification, productSpecificationCreate.resourceSpecification) && Objects.equals(this.serviceSpecification, productSpecificationCreate.serviceSpecification) && Objects.equals(this.targetProductSchema, productSpecificationCreate.targetProductSchema) && Objects.equals(this.validFor, productSpecificationCreate.validFor) && Objects.equals(this.baseType, productSpecificationCreate.baseType) && Objects.equals(this.schemaLocation, productSpecificationCreate.schemaLocation) && Objects.equals(this.type, productSpecificationCreate.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductSpecificationCreate {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    productNumber: ").append(this.toIndentedString(this.productNumber)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    bundledProductSpecification: ").append(this.toIndentedString(this.bundledProductSpecification)).append("\n");
        sb.append("    productSpecCharacteristic: ").append(this.toIndentedString(this.productSpecCharacteristic)).append("\n");
        sb.append("    productSpecificationRelationship: ").append(this.toIndentedString(this.productSpecificationRelationship)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    serviceSpecification: ").append(this.toIndentedString(this.serviceSpecification)).append("\n");
        sb.append("    targetProductSchema: ").append(this.toIndentedString(this.targetProductSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

