/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationCharacteristicValue;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="A use of the ProductSpecificationCharacteristicValue by a ProductOffering to which additional properties (attributes) apply or override the properties of similar properties contained in ProductSpecificationCharacteristicValue. It should be noted that characteristics which their value(s) addressed by this object must exist in corresponding product specification. The available characteristic values for a ProductSpecificationCharacteristic in a Product specification can be modified at the ProductOffering level. For example, a characteristic 'Color' might have values White, Blue, Green, and Red. But, the list of values can be restricted to e.g. White and Blue in an associated product offering. It should be noted that the list of values in 'ProductSpecificationCharacteristicValueUse' is a strict subset of the list of values as defined in the corresponding product specification characteristics.")
@Validated
@Entity(name="ProdSpecCharValueUse")
@Table(name="ProdSpecCharValueUse")
public class ProductSpecificationCharacteristicValueUse
extends BaseEntity {
    @JsonProperty(value="maxCardinality")
    private Integer maxCardinality = null;
    @JsonProperty(value="minCardinality")
    private Integer minCardinality = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="productSpecCharacteristicValue")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductSpecificationCharacteristicValue> productSpecCharacteristicValue = new HashSet<ProductSpecificationCharacteristicValue>();
    @JsonProperty(value="productSpecification")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinColumn(referencedColumnName="uuid")
    private ProductSpecificationRef productSpecification = null;

    public ProductSpecificationCharacteristicValueUse() {
        this.baseType = "BaseEntity";
        this.type = this.getClass().getName();
    }

    public ProductSpecificationCharacteristicValueUse(ProductSpecificationCharacteristicValueUse src) {
        this();
        this.name = src.getName();
        this.description = src.getDescription();
        this.maxCardinality = src.getMaxCardinality();
        this.minCardinality = src.getMinCardinality();
        this.valueType = src.valueType;
        this.updateProductSpecCharacteristicValues(src.getProductSpecCharacteristicValue());
    }

    public ProductSpecificationCharacteristicValueUse maxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
        return this;
    }

    @Schema(description="The maximum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where five is the value for the maxCardinality.")
    public Integer getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public ProductSpecificationCharacteristicValueUse minCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
        return this;
    }

    @Schema(description="The minimum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where zero is the value for the minCardinality.")
    public Integer getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
    }

    public ProductSpecificationCharacteristicValueUse valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on, such as numeric, text and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public ProductSpecificationCharacteristicValueUse productSpecCharacteristicValue(Set<ProductSpecificationCharacteristicValue> productSpecCharacteristicValue) {
        this.productSpecCharacteristicValue = productSpecCharacteristicValue;
        return this;
    }

    public ProductSpecificationCharacteristicValueUse addProductSpecCharacteristicValueItem(ProductSpecificationCharacteristicValue productSpecCharacteristicValueItem) {
        if (this.productSpecCharacteristicValue == null) {
            this.productSpecCharacteristicValue = new HashSet<ProductSpecificationCharacteristicValue>();
        }
        this.productSpecCharacteristicValue.add(productSpecCharacteristicValueItem);
        return this;
    }

    @Schema(description="A number or text that can be assigned to a ProductSpecificationCharacteristic.")
    @Valid
    public Set<ProductSpecificationCharacteristicValue> getProductSpecCharacteristicValue() {
        return this.productSpecCharacteristicValue;
    }

    public void setProductSpecCharacteristicValue(Set<ProductSpecificationCharacteristicValue> productSpecCharacteristicValue) {
        this.productSpecCharacteristicValue = productSpecCharacteristicValue;
    }

    public ProductSpecificationCharacteristicValueUse productSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
        return this;
    }

    @Schema(description="A ProductSpecification is a detailed description of a tangible or intangible object made available externally in the form of a ProductOffering to customers or other parties playing a party role.")
    @Valid
    public ProductSpecificationRef getProductSpecification() {
        return this.productSpecification;
    }

    public void setProductSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductSpecificationCharacteristicValueUse productSpecificationCharacteristicValueUse = (ProductSpecificationCharacteristicValueUse)o;
        return Objects.equals(this.description, productSpecificationCharacteristicValueUse.description) && Objects.equals(this.maxCardinality, productSpecificationCharacteristicValueUse.maxCardinality) && Objects.equals(this.minCardinality, productSpecificationCharacteristicValueUse.minCardinality) && Objects.equals(this.name, productSpecificationCharacteristicValueUse.name) && Objects.equals(this.valueType, productSpecificationCharacteristicValueUse.valueType) && Objects.equals(this.productSpecCharacteristicValue, productSpecificationCharacteristicValueUse.productSpecCharacteristicValue) && Objects.equals(this.productSpecification, productSpecificationCharacteristicValueUse.productSpecification) && Objects.equals(this.validFor, productSpecificationCharacteristicValueUse.validFor) && Objects.equals(this.baseType, productSpecificationCharacteristicValueUse.baseType) && Objects.equals(this.schemaLocation, productSpecificationCharacteristicValueUse.schemaLocation) && Objects.equals(this.type, productSpecificationCharacteristicValueUse.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductSpecificationCharacteristicValueUse {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    maxCardinality: ").append(this.toIndentedString(this.maxCardinality)).append("\n");
        sb.append("    minCardinality: ").append(this.toIndentedString(this.minCardinality)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    productSpecCharacteristicValue: ").append(this.toIndentedString(this.productSpecCharacteristicValue)).append("\n");
        sb.append("    productSpecification: ").append(this.toIndentedString(this.productSpecification)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void updateWith(ProductSpecificationCharacteristicValueUse src) {
        this.name = src.getName();
        this.description = src.getDescription();
        this.maxCardinality = src.getMaxCardinality();
        this.minCardinality = src.getMinCardinality();
        this.updateProductSpecCharacteristicValues(src.getProductSpecCharacteristicValue());
    }

    private void updateProductSpecCharacteristicValues(@Valid Set<ProductSpecificationCharacteristicValue> srcSet) {
        HashMap<Integer, Boolean> idAddedUpdated = new HashMap<Integer, Boolean>();
        for (ProductSpecificationCharacteristicValue r : srcSet) {
            boolean valueExists = false;
            for (ProductSpecificationCharacteristicValue thisCharVal : this.productSpecCharacteristicValue) {
                if (thisCharVal.hashCode() != r.hashCode()) continue;
                valueExists = true;
                idAddedUpdated.put(thisCharVal.hashCode(), true);
                break;
            }
            if (valueExists) continue;
            ProductSpecificationCharacteristicValue nr = new ProductSpecificationCharacteristicValue(r);
            this.addProductSpecCharacteristicValueItem(nr);
            idAddedUpdated.put(nr.hashCode(), true);
        }
        ArrayList<ProductSpecificationCharacteristicValue> toRemove = new ArrayList<ProductSpecificationCharacteristicValue>();
        for (ProductSpecificationCharacteristicValue ss : this.productSpecCharacteristicValue) {
            if (idAddedUpdated.get(ss.hashCode()) != null) continue;
            toRemove.add(ss);
        }
        for (ProductSpecificationCharacteristicValue r : toRemove) {
            this.productSpecCharacteristicValue.remove(r);
        }
    }
}

