/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="A ProductSpecificationCharacteristicValue object is used to define a set of attributes, each of which can be assigned to a corresponding set of attributes in a ProductSpecificationCharacteristic object. The values of the attributes in the ProductSpecificationCharacteristicValue object describe the values of the attributes that a corresponding ProductSpecificationCharacteristic object can take on.")
@Validated
@Entity(name="ProdSpecCharValue")
@Table(name="ProdSpecCharValue")
public class ProductSpecificationCharacteristicValue
extends BaseRootEntity {
    @JsonProperty(value="isDefault")
    private Boolean isDefault = null;
    @JsonProperty(value="rangeInterval")
    private String rangeInterval = null;
    @JsonProperty(value="regex")
    private String regex = null;
    @JsonProperty(value="unitOfMeasure")
    private String unitOfMeasure = null;
    @JsonProperty(value="valueFrom")
    private String valueFrom = null;
    @JsonProperty(value="valueTo")
    private String valueTo = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="value")
    private Any value = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;

    public ProductSpecificationCharacteristicValue() {
    }

    public ProductSpecificationCharacteristicValue(ProductSpecificationCharacteristicValue r) {
        this();
        this.isDefault = r.isDefault;
        this.rangeInterval = r.rangeInterval;
        this.regex = r.regex;
        this.unitOfMeasure = r.unitOfMeasure;
        this.valueFrom = r.valueFrom;
        this.valueTo = r.valueTo;
        this.valueType = r.valueType;
        this.validFor = new TimePeriod(r.validFor);
        this.value = new Any(r.value);
        this.baseType = r.baseType;
    }

    public ProductSpecificationCharacteristicValue isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Schema(description="Indicates if the value is the default value for a characteristic")
    public Boolean isIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public ProductSpecificationCharacteristicValue rangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
        return this;
    }

    @Schema(description="An indicator that specifies the inclusion or exclusion of the valueFrom and valueTo attributes. If applicable, possible values are \"open\", \"closed\", \"closedBottom\" and \"closedTop\".")
    public String getRangeInterval() {
        return this.rangeInterval;
    }

    public void setRangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
    }

    public ProductSpecificationCharacteristicValue regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Schema(description="Regular expression to define constraint on the allowed value")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public ProductSpecificationCharacteristicValue unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="A length, surface, volume, dry measure, liquid measure, money, weight, time, and the like. In general, a determinate quantity or magnitude of the kind designated, taken as a standard of comparison for others of the same kind, in assigning to them numerical values, as 1 foot, 1 yard, 1 mile, 1 square foot.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public ProductSpecificationCharacteristicValue valueFrom(String valueFrom) {
        this.valueFrom = valueFrom;
        return this;
    }

    @Schema(description="The low range value that a characteristic can take on")
    public String getValueFrom() {
        return this.valueFrom;
    }

    public void setValueFrom(String valueFrom) {
        this.valueFrom = valueFrom;
    }

    public ProductSpecificationCharacteristicValue valueTo(String valueTo) {
        this.valueTo = valueTo;
        return this;
    }

    @Schema(description="The period for which the entity is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Schema(description="The upper range value that a characteristic can take on")
    public String getValueTo() {
        return this.valueTo;
    }

    public void setValueTo(String valueTo) {
        this.valueTo = valueTo;
    }

    public ProductSpecificationCharacteristicValue valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on, such as numeric, text, and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public ProductSpecificationCharacteristicValue value(Any value) {
        this.value = value;
        return this;
    }

    @Schema(description="A discrete value that the characteristic can take on, or the actual value of the characteristic")
    @Valid
    public Any getValue() {
        return this.value;
    }

    public void setValue(Any value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductSpecificationCharacteristicValue productSpecificationCharacteristicValue = (ProductSpecificationCharacteristicValue)o;
        return Objects.equals(this.isDefault, productSpecificationCharacteristicValue.isDefault) && Objects.equals(this.rangeInterval, productSpecificationCharacteristicValue.rangeInterval) && Objects.equals(this.regex, productSpecificationCharacteristicValue.regex) && Objects.equals(this.unitOfMeasure, productSpecificationCharacteristicValue.unitOfMeasure) && Objects.equals(this.valueFrom, productSpecificationCharacteristicValue.valueFrom) && Objects.equals(this.valueTo, productSpecificationCharacteristicValue.valueTo) && Objects.equals(this.valueType, productSpecificationCharacteristicValue.valueType) && Objects.equals(this.validFor, productSpecificationCharacteristicValue.validFor) && Objects.equals(this.value, productSpecificationCharacteristicValue.value) && Objects.equals(this.baseType, productSpecificationCharacteristicValue.baseType) && Objects.equals(this.schemaLocation, productSpecificationCharacteristicValue.schemaLocation) && Objects.equals(this.type, productSpecificationCharacteristicValue.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductSpecificationCharacteristicValue {\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    rangeInterval: ").append(this.toIndentedString(this.rangeInterval)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    valueFrom: ").append(this.toIndentedString(this.valueFrom)).append("\n");
        sb.append("    valueTo: ").append(this.toIndentedString(this.valueTo)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

