/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="An aggregation, migration, substitution, dependency or exclusivity relationship between/among productSpecificationCharacteristics.")
@Validated
@Entity(name="ProdSpecCharRelationship")
@Table(name="ProdSpecCharRelationship")
public class ProductSpecificationCharacteristicRelationship
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="charSpecSeq")
    private Integer charSpecSeq = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;

    public ProductSpecificationCharacteristicRelationship getNewProductSpecificationCharacteristicRelationship(ProductSpecificationCharacteristicRelationship src) {
        ProductSpecificationCharacteristicRelationship newp = new ProductSpecificationCharacteristicRelationship();
        newp.name = src.name;
        newp.relationshipType = src.relationshipType;
        newp.validFor = new TimePeriod(src.validFor);
        newp.id = src.id;
        return newp;
    }

    public ProductSpecificationCharacteristicRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="the identifier of the associated product specification")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProductSpecificationCharacteristicRelationship charSpecSeq(Integer charSpecSeq) {
        this.charSpecSeq = charSpecSeq;
        return this;
    }

    @Schema(description="The order in which a CharacteristicSpecification appears within another CharacteristicSpecification that defines a grouping of CharacteristicSpecifications.  For example, a grouping may represent the name of an individual. The given name is first, the middle name is second, and the last name is third.")
    public Integer getCharSpecSeq() {
        return this.charSpecSeq;
    }

    public void setCharSpecSeq(Integer charSpecSeq) {
        this.charSpecSeq = charSpecSeq;
    }

    public ProductSpecificationCharacteristicRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of relationship such as aggregation, migration, substitution, dependency, exclusivity")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductSpecificationCharacteristicRelationship productSpecificationCharacteristicRelationship = (ProductSpecificationCharacteristicRelationship)o;
        return Objects.equals(this.id, productSpecificationCharacteristicRelationship.id) && Objects.equals(this.href, productSpecificationCharacteristicRelationship.href) && Objects.equals(this.charSpecSeq, productSpecificationCharacteristicRelationship.charSpecSeq) && Objects.equals(this.name, productSpecificationCharacteristicRelationship.name) && Objects.equals(this.relationshipType, productSpecificationCharacteristicRelationship.relationshipType) && Objects.equals(this.validFor, productSpecificationCharacteristicRelationship.validFor) && Objects.equals(this.baseType, productSpecificationCharacteristicRelationship.baseType) && Objects.equals(this.schemaLocation, productSpecificationCharacteristicRelationship.schemaLocation) && Objects.equals(this.type, productSpecificationCharacteristicRelationship.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductSpecificationCharacteristicRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    charSpecSeq: ").append(this.toIndentedString(this.charSpecSeq)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

