/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationCharacteristicRelationship;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationCharacteristicValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="A characteristic quality or distinctive feature of a ProductSpecification.  The characteristic can be take on a discrete value, such as color, can take on a range of values, (for example, sensitivity of 100-240 mV), or can be derived from a formula (for example, usage time (hrs) = 30 - talk time *3). Certain characteristics, such as color, may be configured during the ordering or some other process.")
@Validated
@Entity(name="ProdSpecChar")
@Table(name="ProdSpecChar")
public class ProductSpecificationCharacteristic
extends BaseEntity {
    @JsonProperty(value="configurable")
    private Boolean configurable = null;
    @JsonProperty(value="extensible")
    private Boolean extensible = null;
    @JsonProperty(value="isUnique")
    private Boolean isUnique = null;
    @JsonProperty(value="maxCardinality")
    private Integer maxCardinality = null;
    @JsonProperty(value="minCardinality")
    private Integer minCardinality = null;
    @JsonProperty(value="regex")
    private String regex = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="productSpecCharRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductSpecificationCharacteristicRelationship> productSpecCharRelationship = new HashSet<ProductSpecificationCharacteristicRelationship>();
    @JsonProperty(value="productSpecCharacteristicValue")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductSpecificationCharacteristicValue> productSpecCharacteristicValue = new HashSet<ProductSpecificationCharacteristicValue>();

    public ProductSpecificationCharacteristic configurable(Boolean configurable) {
        this.configurable = configurable;
        return this;
    }

    @Schema(description="If true, the Boolean indicates that the ProductSpecificationCharacteristic is configurable")
    public Boolean isConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    public ProductSpecificationCharacteristic extensible(Boolean extensible) {
        this.extensible = extensible;
        return this;
    }

    @Schema(description="An indicator that specifies that the values for the characteristic can be extended by adding new values when instantiating a characteristic for a product")
    public Boolean isExtensible() {
        return this.extensible;
    }

    public void setExtensible(Boolean extensible) {
        this.extensible = extensible;
    }

    public ProductSpecificationCharacteristic isUnique(Boolean isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    @Schema(description="An indicator that specifies if a value is unique for the specification. Possible values are; \"unique while value is in effect\" and \"unique whether value is in effect or not\"")
    public Boolean isIsUnique() {
        return this.isUnique;
    }

    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }

    public ProductSpecificationCharacteristic maxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
        return this;
    }

    @Schema(description="The maximum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where five is the value for the maxCardinality")
    public Integer getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public ProductSpecificationCharacteristic minCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
        return this;
    }

    @Schema(description="The minimum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where zero is the value for the minCardinality")
    public Integer getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
    }

    public ProductSpecificationCharacteristic regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Schema(description="A rule or principle represented in regular expression used to derive the value of a characteristic value")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public ProductSpecificationCharacteristic valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on, such as numeric, text and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public ProductSpecificationCharacteristic productSpecCharRelationship(Set<ProductSpecificationCharacteristicRelationship> productSpecCharRelationship) {
        this.productSpecCharRelationship = productSpecCharRelationship;
        return this;
    }

    public ProductSpecificationCharacteristic addProductSpecCharRelationshipItem(ProductSpecificationCharacteristicRelationship productSpecCharRelationshipItem) {
        if (this.productSpecCharRelationship == null) {
            this.productSpecCharRelationship = new HashSet<ProductSpecificationCharacteristicRelationship>();
        }
        this.productSpecCharRelationship.add(productSpecCharRelationshipItem);
        return this;
    }

    @Schema(description="An aggregation, migration, substitution, dependency or exclusivity relationship between/among Specification Characteristics.")
    @Valid
    public Set<ProductSpecificationCharacteristicRelationship> getProductSpecCharRelationship() {
        return this.productSpecCharRelationship;
    }

    public void setProductSpecCharRelationship(Set<ProductSpecificationCharacteristicRelationship> productSpecCharRelationship) {
        this.productSpecCharRelationship = productSpecCharRelationship;
    }

    public ProductSpecificationCharacteristic productSpecCharacteristicValue(Set<ProductSpecificationCharacteristicValue> productSpecCharacteristicValue) {
        this.productSpecCharacteristicValue = productSpecCharacteristicValue;
        return this;
    }

    public ProductSpecificationCharacteristic addProductSpecCharacteristicValueItem(ProductSpecificationCharacteristicValue productSpecCharacteristicValueItem) {
        if (this.productSpecCharacteristicValue == null) {
            this.productSpecCharacteristicValue = new HashSet<ProductSpecificationCharacteristicValue>();
        }
        this.productSpecCharacteristicValue.add(productSpecCharacteristicValueItem);
        return this;
    }

    @Schema(description="A ProductSpecificationCharacteristicValue object is used to define a set of attributes, each of which can be assigned to a corresponding set of attributes in a ProductSpecificationCharacteristic object. The values of the attributes in the ProductSpecificationCharacteristicValue object describe the values of the attributes that a corresponding ProductSpecificationCharacteristic object can take on.")
    @Valid
    public Set<ProductSpecificationCharacteristicValue> getProductSpecCharacteristicValue() {
        return this.productSpecCharacteristicValue;
    }

    public void setProductSpecCharacteristicValue(Set<ProductSpecificationCharacteristicValue> productSpecCharacteristicValue) {
        this.productSpecCharacteristicValue = productSpecCharacteristicValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductSpecificationCharacteristic productSpecificationCharacteristic = (ProductSpecificationCharacteristic)o;
        return Objects.equals(this.configurable, productSpecificationCharacteristic.configurable) && Objects.equals(this.description, productSpecificationCharacteristic.description) && Objects.equals(this.extensible, productSpecificationCharacteristic.extensible) && Objects.equals(this.isUnique, productSpecificationCharacteristic.isUnique) && Objects.equals(this.maxCardinality, productSpecificationCharacteristic.maxCardinality) && Objects.equals(this.minCardinality, productSpecificationCharacteristic.minCardinality) && Objects.equals(this.name, productSpecificationCharacteristic.name) && Objects.equals(this.regex, productSpecificationCharacteristic.regex) && Objects.equals(this.valueType, productSpecificationCharacteristic.valueType) && Objects.equals(this.productSpecCharRelationship, productSpecificationCharacteristic.productSpecCharRelationship) && Objects.equals(this.productSpecCharacteristicValue, productSpecificationCharacteristic.productSpecCharacteristicValue) && Objects.equals(this.validFor, productSpecificationCharacteristic.validFor) && Objects.equals(this.baseType, productSpecificationCharacteristic.baseType) && Objects.equals(this.schemaLocation, productSpecificationCharacteristic.schemaLocation) && Objects.equals(this.type, productSpecificationCharacteristic.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductSpecificationCharacteristic {\n");
        sb.append("    configurable: ").append(this.toIndentedString(this.configurable)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    extensible: ").append(this.toIndentedString(this.extensible)).append("\n");
        sb.append("    isUnique: ").append(this.toIndentedString(this.isUnique)).append("\n");
        sb.append("    maxCardinality: ").append(this.toIndentedString(this.maxCardinality)).append("\n");
        sb.append("    minCardinality: ").append(this.toIndentedString(this.minCardinality)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    productSpecCharRelationship: ").append(this.toIndentedString(this.productSpecCharRelationship)).append("\n");
        sb.append("    productSpecCharacteristicValue: ").append(this.toIndentedString(this.productSpecCharacteristicValue)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void updateWith(ProductSpecificationCharacteristic src) {
        this.name = src.getName();
        this.description = src.getDescription();
        this.maxCardinality = src.getMaxCardinality();
        this.minCardinality = src.getMinCardinality();
        this.regex = src.getRegex();
        this.isUnique = src.isUnique;
        this.configurable = src.isConfigurable();
        this.extensible = src.isExtensible();
        this.valueType = src.valueType;
        this.updateProductSpecCharacteristicValues(src.getProductSpecCharacteristicValue());
        this.updateProductSpecCharRelationships(src.getProductSpecCharRelationship());
    }

    private void updateProductSpecCharacteristicValues(@Valid Set<ProductSpecificationCharacteristicValue> srcSet) {
        if (srcSet == null) {
            return;
        }
        HashMap<Integer, Boolean> idAddedUpdated = new HashMap<Integer, Boolean>();
        for (ProductSpecificationCharacteristicValue r : srcSet) {
            boolean valueExists = false;
            for (ProductSpecificationCharacteristicValue thisCharVal : this.productSpecCharacteristicValue) {
                if (thisCharVal.hashCode() != r.hashCode()) continue;
                valueExists = true;
                idAddedUpdated.put(thisCharVal.hashCode(), true);
                break;
            }
            if (valueExists) continue;
            ProductSpecificationCharacteristicValue nr = new ProductSpecificationCharacteristicValue(r);
            this.addProductSpecCharacteristicValueItem(nr);
            idAddedUpdated.put(nr.hashCode(), true);
        }
        ArrayList<ProductSpecificationCharacteristicValue> toRemove = new ArrayList<ProductSpecificationCharacteristicValue>();
        for (ProductSpecificationCharacteristicValue ss : this.productSpecCharacteristicValue) {
            if (idAddedUpdated.get(ss.hashCode()) != null) continue;
            toRemove.add(ss);
        }
        for (ProductSpecificationCharacteristicValue r : toRemove) {
            this.productSpecCharacteristicValue.remove(r);
        }
    }

    private void updateProductSpecCharRelationships(@Valid Set<ProductSpecificationCharacteristicRelationship> productSpecCharRelationship2) {
        HashMap<String, Boolean> idAddedUpdated = new HashMap<String, Boolean>();
        for (ProductSpecificationCharacteristicRelationship r : productSpecCharRelationship2) {
            boolean valueExists = false;
            for (ProductSpecificationCharacteristicRelationship thisCharVal : this.productSpecCharRelationship) {
                if (thisCharVal.getId() == null || !thisCharVal.getId().equals(r.getId())) continue;
                valueExists = true;
                idAddedUpdated.put(thisCharVal.getId(), true);
                break;
            }
            if (valueExists) continue;
            this.productSpecCharRelationship.add(r.getNewProductSpecificationCharacteristicRelationship(r));
            idAddedUpdated.put(r.getId(), true);
        }
        ArrayList<ProductSpecificationCharacteristicRelationship> toRemove = new ArrayList<ProductSpecificationCharacteristicRelationship>();
        for (ProductSpecificationCharacteristicRelationship ss : this.productSpecCharRelationship) {
            if (idAddedUpdated.get(ss.getId()) != null) continue;
            toRemove.add(ss);
        }
        for (ProductSpecificationCharacteristicRelationship r : toRemove) {
            this.productSpecCharRelationship.remove(r);
        }
    }
}

