/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.pcm620.model.BundledProductSpecification;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationCharacteristic;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationRelationship;
import org.etsi.osl.tmf.pcm620.model.TargetProductSchema;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Is a detailed description of a tangible or intangible object made available externally in the form of a ProductOffering to customers or other parties playing a party role.")
@Validated
@Entity
public class ProductSpecification
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="brand")
    private String brand = null;
    @JsonProperty(value="isBundle")
    private Boolean isBundle = null;
    @JsonProperty(value="productNumber")
    private String productNumber = null;
    @JsonProperty(value="attachment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AttachmentRefOrValue> attachment = new HashSet<AttachmentRefOrValue>();
    @JsonProperty(value="bundledProductSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<BundledProductSpecification> bundledProductSpecification = new HashSet<BundledProductSpecification>();
    @JsonProperty(value="productSpecCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductSpecificationCharacteristic> productSpecCharacteristic = new HashSet<ProductSpecificationCharacteristic>();
    @JsonProperty(value="productSpecificationRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductSpecificationRelationship> productSpecificationRelationship = new HashSet<ProductSpecificationRelationship>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="resourceSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceSpecificationRef> resourceSpecification = new HashSet<ResourceSpecificationRef>();
    @JsonProperty(value="serviceSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceSpecificationRef> serviceSpecification = new HashSet<ServiceSpecificationRef>();
    @JsonProperty(value="targetProductSchema")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinColumn(referencedColumnName="uuid")
    private TargetProductSchema targetProductSchema = null;

    public ProductSpecification id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the product specification")
    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    @Schema(description="The manufacturer or trademark of the specification")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public ProductSpecification isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="isBundle determines whether a productSpecification represents a single productSpecification (false), or a bundle of productSpecification (true).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ProductSpecification productNumber(String productNumber) {
        this.productNumber = productNumber;
        return this;
    }

    @Schema(description="An identification number assigned to uniquely identity the specification")
    public String getProductNumber() {
        return this.productNumber;
    }

    public void setProductNumber(String productNumber) {
        this.productNumber = productNumber;
    }

    public ProductSpecification attachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ProductSpecification addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new HashSet<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="Complements the description of an element (for instance a product) through video, pictures...")
    @Valid
    public Set<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public ProductSpecification bundledProductSpecification(Set<BundledProductSpecification> bundledProductSpecification) {
        this.bundledProductSpecification = bundledProductSpecification;
        return this;
    }

    public ProductSpecification addBundledProductSpecificationItem(BundledProductSpecification bundledProductSpecificationItem) {
        if (this.bundledProductSpecification == null) {
            this.bundledProductSpecification = new HashSet<BundledProductSpecification>();
        }
        this.bundledProductSpecification.add(bundledProductSpecificationItem);
        return this;
    }

    @Schema(description="A type of ProductSpecification that belongs to a grouping of ProductSpecifications made available to the market. It inherits of all attributes of ProductSpecification.")
    @Valid
    public Set<BundledProductSpecification> getBundledProductSpecification() {
        return this.bundledProductSpecification;
    }

    public void setBundledProductSpecification(Set<BundledProductSpecification> bundledProductSpecification) {
        this.bundledProductSpecification = bundledProductSpecification;
    }

    public ProductSpecification productSpecCharacteristic(Set<ProductSpecificationCharacteristic> productSpecCharacteristic) {
        this.productSpecCharacteristic = productSpecCharacteristic;
        return this;
    }

    public ProductSpecification addProductSpecCharacteristicItem(ProductSpecificationCharacteristic productSpecCharacteristicItem) {
        if (this.productSpecCharacteristic == null) {
            this.productSpecCharacteristic = new HashSet<ProductSpecificationCharacteristic>();
        }
        this.productSpecCharacteristic.add(productSpecCharacteristicItem);
        return this;
    }

    @Schema(description="A characteristic quality or distinctive feature of a ProductSpecification.  The characteristic can be take on a discrete value, such as color, can take on a range of values, (for example, sensitivity of 100-240 mV), or can be derived from a formula (for example, usage time (hrs) = 30 - talk time *3). Certain characteristics, such as color, may be configured during the ordering or some other process.")
    @Valid
    public Set<ProductSpecificationCharacteristic> getProductSpecCharacteristic() {
        return this.productSpecCharacteristic;
    }

    public void setProductSpecCharacteristic(Set<ProductSpecificationCharacteristic> productSpecCharacteristic) {
        this.productSpecCharacteristic = productSpecCharacteristic;
    }

    public ProductSpecification productSpecificationRelationship(Set<ProductSpecificationRelationship> productSpecificationRelationship) {
        this.productSpecificationRelationship = productSpecificationRelationship;
        return this;
    }

    public ProductSpecification addProductSpecificationRelationshipItem(ProductSpecificationRelationship productSpecificationRelationshipItem) {
        if (this.productSpecificationRelationship == null) {
            this.productSpecificationRelationship = new HashSet<ProductSpecificationRelationship>();
        }
        this.productSpecificationRelationship.add(productSpecificationRelationshipItem);
        return this;
    }

    @Schema(description="A migration, substitution, dependency or exclusivity relationship between/among product specifications.")
    @Valid
    public Set<ProductSpecificationRelationship> getProductSpecificationRelationship() {
        return this.productSpecificationRelationship;
    }

    public void setProductSpecificationRelationship(Set<ProductSpecificationRelationship> productSpecificationRelationship) {
        this.productSpecificationRelationship = productSpecificationRelationship;
    }

    public ProductSpecification relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ProductSpecification addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A related party defines party or party role linked to a specific entity.")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ProductSpecification resourceSpecification(Set<ResourceSpecificationRef> resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    public ProductSpecification addResourceSpecificationItem(ResourceSpecificationRef resourceSpecificationItem) {
        if (this.resourceSpecification == null) {
            this.resourceSpecification = new HashSet<ResourceSpecificationRef>();
        }
        this.resourceSpecification.add(resourceSpecificationItem);
        return this;
    }

    @Schema(description="The ResourceSpecification is required to realize a ProductSpecification.")
    @Valid
    public Set<ResourceSpecificationRef> getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(Set<ResourceSpecificationRef> resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public ProductSpecification serviceSpecification(Set<ServiceSpecificationRef> serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
        return this;
    }

    public ProductSpecification addServiceSpecificationItem(ServiceSpecificationRef serviceSpecificationItem) {
        if (this.serviceSpecification == null) {
            this.serviceSpecification = new HashSet<ServiceSpecificationRef>();
        }
        this.serviceSpecification.add(serviceSpecificationItem);
        return this;
    }

    @Schema(description="ServiceSpecification(s) required to realize a ProductSpecification.")
    @Valid
    public Set<ServiceSpecificationRef> getServiceSpecification() {
        return this.serviceSpecification;
    }

    public void setServiceSpecification(Set<ServiceSpecificationRef> serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
    }

    public ProductSpecification targetProductSchema(TargetProductSchema targetProductSchema) {
        this.targetProductSchema = targetProductSchema;
        return this;
    }

    @Schema(description="A target product schema reference. The reference object to the schema and type of target product which is described by product specification.")
    @Valid
    public TargetProductSchema getTargetProductSchema() {
        return this.targetProductSchema;
    }

    public void setTargetProductSchema(TargetProductSchema targetProductSchema) {
        this.targetProductSchema = targetProductSchema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductSpecification productSpecification = (ProductSpecification)o;
        return Objects.equals(this.id, productSpecification.id) && Objects.equals(this.href, productSpecification.href) && Objects.equals(this.brand, productSpecification.brand) && Objects.equals(this.description, productSpecification.description) && Objects.equals(this.isBundle, productSpecification.isBundle) && Objects.equals(this.lastUpdate, productSpecification.lastUpdate) && Objects.equals(this.lifecycleStatus, productSpecification.lifecycleStatus) && Objects.equals(this.name, productSpecification.name) && Objects.equals(this.productNumber, productSpecification.productNumber) && Objects.equals(this.version, productSpecification.version) && Objects.equals(this.attachment, productSpecification.attachment) && Objects.equals(this.bundledProductSpecification, productSpecification.bundledProductSpecification) && Objects.equals(this.productSpecCharacteristic, productSpecification.productSpecCharacteristic) && Objects.equals(this.productSpecificationRelationship, productSpecification.productSpecificationRelationship) && Objects.equals(this.relatedParty, productSpecification.relatedParty) && Objects.equals(this.resourceSpecification, productSpecification.resourceSpecification) && Objects.equals(this.serviceSpecification, productSpecification.serviceSpecification) && Objects.equals(this.targetProductSchema, productSpecification.targetProductSchema) && Objects.equals(this.validFor, productSpecification.validFor) && Objects.equals(this.baseType, productSpecification.baseType) && Objects.equals(this.schemaLocation, productSpecification.schemaLocation) && Objects.equals(this.type, productSpecification.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    productNumber: ").append(this.toIndentedString(this.productNumber)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    bundledProductSpecification: ").append(this.toIndentedString(this.bundledProductSpecification)).append("\n");
        sb.append("    productSpecCharacteristic: ").append(this.toIndentedString(this.productSpecCharacteristic)).append("\n");
        sb.append("    productSpecificationRelationship: ").append(this.toIndentedString(this.productSpecificationRelationship)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    serviceSpecification: ").append(this.toIndentedString(this.serviceSpecification)).append("\n");
        sb.append("    targetProductSchema: ").append(this.toIndentedString(this.targetProductSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public ProductSpecificationCharacteristic findProdCharacteristicByName(String an) {
        for (ProductSpecificationCharacteristic ssci : this.getProductSpecCharacteristic()) {
            if (ssci.getName() == null || !ssci.getName().equals(an)) continue;
            return ssci;
        }
        return null;
    }
}

