/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am651.model.AgreementRef;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pcm620.model.BundledProductOffering;
import org.etsi.osl.tmf.pcm620.model.CategoryRef;
import org.etsi.osl.tmf.pcm620.model.ChannelRef;
import org.etsi.osl.tmf.pcm620.model.MarketSegmentRef;
import org.etsi.osl.tmf.pcm620.model.PlaceRef;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPriceRef;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingTerm;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationCharacteristicValueUse;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationRef;
import org.etsi.osl.tmf.pcm620.model.ResourceCandidateRef;
import org.etsi.osl.tmf.pcm620.model.SLARef;
import org.etsi.osl.tmf.pcm620.model.ServiceCandidateRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Represents entities that are orderable from the provider of the catalog, this resource includes pricing information. Skipped properties: id,href,lastUpdate")
@Validated
public class ProductOfferingUpdate {
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="isBundle")
    protected Boolean isBundle = null;
    @JsonProperty(value="isSellable")
    protected Boolean isSellable = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="statusReason")
    protected String statusReason = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="agreement")
    @Valid
    protected List<AgreementRef> agreement = null;
    @JsonProperty(value="attachment")
    @Valid
    protected List<AttachmentRefOrValue> attachment = null;
    @JsonProperty(value="bundledProductOffering")
    @Valid
    protected List<BundledProductOffering> bundledProductOffering = null;
    @JsonProperty(value="category")
    @Valid
    protected List<CategoryRef> category = null;
    @JsonProperty(value="channel")
    @Valid
    protected List<ChannelRef> channel = null;
    @JsonProperty(value="marketSegment")
    @Valid
    protected List<MarketSegmentRef> marketSegment = null;
    @JsonProperty(value="place")
    @Valid
    protected List<PlaceRef> place = null;
    @JsonProperty(value="prodSpecCharValueUse")
    @Valid
    protected List<ProductSpecificationCharacteristicValueUse> prodSpecCharValueUse = null;
    @JsonProperty(value="productOfferingPrice")
    @Valid
    protected List<ProductOfferingPriceRef> productOfferingPrice = null;
    @JsonProperty(value="productOfferingTerm")
    @Valid
    protected List<ProductOfferingTerm> productOfferingTerm = null;
    @JsonProperty(value="productSpecification")
    protected ProductSpecificationRef productSpecification = null;
    @JsonProperty(value="resourceCandidate")
    protected ResourceCandidateRef resourceCandidate = null;
    @JsonProperty(value="serviceCandidate")
    protected ServiceCandidateRef serviceCandidate = null;
    @JsonProperty(value="serviceLevelAgreement")
    protected SLARef serviceLevelAgreement = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ProductOfferingUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the productOffering")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProductOfferingUpdate isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="isBundle determines whether a productOffering represents a single productOffering (false), or a bundle of productOfferings (true).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ProductOfferingUpdate isSellable(Boolean isSellable) {
        this.isSellable = isSellable;
        return this;
    }

    @Schema(description="A flag indicating if this product offer can be sold stand-alone for sale or not. If this flag is false it indicates that the offer can only be sold within a bundle.")
    public Boolean isIsSellable() {
        return this.isSellable;
    }

    public void setIsSellable(Boolean isSellable) {
        this.isSellable = isSellable;
    }

    public ProductOfferingUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ProductOfferingUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the productOffering")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProductOfferingUpdate statusReason(String statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    @Schema(description="A string providing a complementary information on the value of the lifecycle status attribute.")
    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public ProductOfferingUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="ProductOffering version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ProductOfferingUpdate agreement(List<AgreementRef> agreement) {
        this.agreement = agreement;
        return this;
    }

    public ProductOfferingUpdate addAgreementItem(AgreementRef agreementItem) {
        if (this.agreement == null) {
            this.agreement = new ArrayList<AgreementRef>();
        }
        this.agreement.add(agreementItem);
        return this;
    }

    @Schema(description="An agreement represents a contract or arrangement, either written or verbal and sometimes enforceable by law, such as a service level agreement or a customer price agreement. An agreement involves a number of other business entities, such as products, services, and resources and/or their specifications.")
    @Valid
    public List<AgreementRef> getAgreement() {
        return this.agreement;
    }

    public void setAgreement(List<AgreementRef> agreement) {
        this.agreement = agreement;
    }

    public ProductOfferingUpdate attachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ProductOfferingUpdate addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="Complements the description of an element (for instance a product) through video, pictures...")
    @Valid
    public List<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public ProductOfferingUpdate bundledProductOffering(List<BundledProductOffering> bundledProductOffering) {
        this.bundledProductOffering = bundledProductOffering;
        return this;
    }

    public ProductOfferingUpdate addBundledProductOfferingItem(BundledProductOffering bundledProductOfferingItem) {
        if (this.bundledProductOffering == null) {
            this.bundledProductOffering = new ArrayList<BundledProductOffering>();
        }
        this.bundledProductOffering.add(bundledProductOfferingItem);
        return this;
    }

    @Schema(description="A type of ProductOffering that belongs to a grouping of ProductOfferings made available to the market. It inherits of all attributes of ProductOffering.")
    @Valid
    public List<BundledProductOffering> getBundledProductOffering() {
        return this.bundledProductOffering;
    }

    public void setBundledProductOffering(List<BundledProductOffering> bundledProductOffering) {
        this.bundledProductOffering = bundledProductOffering;
    }

    public ProductOfferingUpdate category(List<CategoryRef> category) {
        this.category = category;
        return this;
    }

    public ProductOfferingUpdate addCategoryItem(CategoryRef categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<CategoryRef>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Schema(description="The category resource is used to group product offerings, service and resource candidates in logical containers. Categories can contain other categories and/or product offerings, resource or service candidates.")
    @Valid
    public List<CategoryRef> getCategory() {
        return this.category;
    }

    public void setCategory(List<CategoryRef> category) {
        this.category = category;
    }

    public ProductOfferingUpdate channel(List<ChannelRef> channel) {
        this.channel = channel;
        return this;
    }

    public ProductOfferingUpdate addChannelItem(ChannelRef channelItem) {
        if (this.channel == null) {
            this.channel = new ArrayList<ChannelRef>();
        }
        this.channel.add(channelItem);
        return this;
    }

    @Schema(description="The channel defines the channel for selling product offerings.")
    @Valid
    public List<ChannelRef> getChannel() {
        return this.channel;
    }

    public void setChannel(List<ChannelRef> channel) {
        this.channel = channel;
    }

    public ProductOfferingUpdate marketSegment(List<MarketSegmentRef> marketSegment) {
        this.marketSegment = marketSegment;
        return this;
    }

    public ProductOfferingUpdate addMarketSegmentItem(MarketSegmentRef marketSegmentItem) {
        if (this.marketSegment == null) {
            this.marketSegment = new ArrayList<MarketSegmentRef>();
        }
        this.marketSegment.add(marketSegmentItem);
        return this;
    }

    @Schema(description="provides references to the corresponding market segment as target of product offerings. A market segment is grouping of Parties, GeographicAreas, SalesChannels, and so forth.")
    @Valid
    public List<MarketSegmentRef> getMarketSegment() {
        return this.marketSegment;
    }

    public void setMarketSegment(List<MarketSegmentRef> marketSegment) {
        this.marketSegment = marketSegment;
    }

    public ProductOfferingUpdate place(List<PlaceRef> place) {
        this.place = place;
        return this;
    }

    public ProductOfferingUpdate addPlaceItem(PlaceRef placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<PlaceRef>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="Place defines the places where the products are sold or delivered.")
    @Valid
    public List<PlaceRef> getPlace() {
        return this.place;
    }

    public void setPlace(List<PlaceRef> place) {
        this.place = place;
    }

    public ProductOfferingUpdate prodSpecCharValueUse(List<ProductSpecificationCharacteristicValueUse> prodSpecCharValueUse) {
        this.prodSpecCharValueUse = prodSpecCharValueUse;
        return this;
    }

    public ProductOfferingUpdate addProdSpecCharValueUseItem(ProductSpecificationCharacteristicValueUse prodSpecCharValueUseItem) {
        if (this.prodSpecCharValueUse == null) {
            this.prodSpecCharValueUse = new ArrayList<ProductSpecificationCharacteristicValueUse>();
        }
        this.prodSpecCharValueUse.add(prodSpecCharValueUseItem);
        return this;
    }

    @Schema(description="A use of the ProductSpecificationCharacteristicValue by a ProductOffering to which additional properties (attributes) apply or override the properties of similar properties contained in ProductSpecificationCharacteristicValue. It should be noted that characteristics which their value(s) addressed by this object must exist in corresponding product specification. The available characteristic values for a ProductSpecificationCharacteristic in a Product specification can be modified at the ProductOffering level. For example, a characteristic 'Color' might have values White, Blue, Green, and Red. But, the list of values can be restricted to e.g. White and Blue in an associated product offering. It should be noted that the list of values in 'ProductSpecificationCharacteristicValueUse' is a strict subset of the list of values as defined in the corresponding product specification characteristics.")
    @Valid
    public List<ProductSpecificationCharacteristicValueUse> getProdSpecCharValueUse() {
        return this.prodSpecCharValueUse;
    }

    public void setProdSpecCharValueUse(List<ProductSpecificationCharacteristicValueUse> prodSpecCharValueUse) {
        this.prodSpecCharValueUse = prodSpecCharValueUse;
    }

    public ProductOfferingUpdate productOfferingPrice(List<ProductOfferingPriceRef> productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
        return this;
    }

    public ProductOfferingUpdate addProductOfferingPriceItem(ProductOfferingPriceRef productOfferingPriceItem) {
        if (this.productOfferingPrice == null) {
            this.productOfferingPrice = new ArrayList<ProductOfferingPriceRef>();
        }
        this.productOfferingPrice.add(productOfferingPriceItem);
        return this;
    }

    @Schema(description="An amount, usually of money, that is asked for or allowed when a ProductOffering is bought, rented, or leased. The price is valid for a defined period of time and may not represent the actual price paid by a customer.")
    @Valid
    public List<ProductOfferingPriceRef> getProductOfferingPrice() {
        return this.productOfferingPrice;
    }

    public void setProductOfferingPrice(List<ProductOfferingPriceRef> productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
    }

    public ProductOfferingUpdate productOfferingTerm(List<ProductOfferingTerm> productOfferingTerm) {
        this.productOfferingTerm = productOfferingTerm;
        return this;
    }

    public ProductOfferingUpdate addProductOfferingTermItem(ProductOfferingTerm productOfferingTermItem) {
        if (this.productOfferingTerm == null) {
            this.productOfferingTerm = new ArrayList<ProductOfferingTerm>();
        }
        this.productOfferingTerm.add(productOfferingTermItem);
        return this;
    }

    @Schema(description="A condition under which a ProductOffering is made available to Customers. For instance, a productOffering can be offered with multiple commitment periods.")
    @Valid
    public List<ProductOfferingTerm> getProductOfferingTerm() {
        return this.productOfferingTerm;
    }

    public void setProductOfferingTerm(List<ProductOfferingTerm> productOfferingTerm) {
        this.productOfferingTerm = productOfferingTerm;
    }

    public ProductOfferingUpdate productSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
        return this;
    }

    @Schema(description="A ProductSpecification is a detailed description of a tangible or intangible object made available externally in the form of a ProductOffering to customers or other parties playing a party role.")
    @Valid
    public ProductSpecificationRef getProductSpecification() {
        return this.productSpecification;
    }

    public void setProductSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
    }

    public ProductOfferingUpdate resourceCandidate(ResourceCandidateRef resourceCandidate) {
        this.resourceCandidate = resourceCandidate;
        return this;
    }

    @Schema(description="A resource candidate is an entity that makes a ResourceSpecification available to a catalog.")
    @Valid
    public ResourceCandidateRef getResourceCandidate() {
        return this.resourceCandidate;
    }

    public void setResourceCandidate(ResourceCandidateRef resourceCandidate) {
        this.resourceCandidate = resourceCandidate;
    }

    public ProductOfferingUpdate serviceCandidate(ServiceCandidateRef serviceCandidate) {
        this.serviceCandidate = serviceCandidate;
        return this;
    }

    @Schema(description="ServiceCandidate is an entity that makes a ServiceSpecification available to a catalog.")
    @Valid
    public ServiceCandidateRef getServiceCandidate() {
        return this.serviceCandidate;
    }

    public void setServiceCandidate(ServiceCandidateRef serviceCandidate) {
        this.serviceCandidate = serviceCandidate;
    }

    public ProductOfferingUpdate serviceLevelAgreement(SLARef serviceLevelAgreement) {
        this.serviceLevelAgreement = serviceLevelAgreement;
        return this;
    }

    @Schema(description="A service level agreement (SLA) is a type of agreement that represents a formal negotiated agreement between two parties designed to create a common understanding about products, services, priorities, responsibilities, and so forth. The SLA is a set of appropriate procedures and targets formally or informally agreed between parties in order to achieve and maintain specified Quality of Service.")
    @Valid
    public SLARef getServiceLevelAgreement() {
        return this.serviceLevelAgreement;
    }

    public void setServiceLevelAgreement(SLARef serviceLevelAgreement) {
        this.serviceLevelAgreement = serviceLevelAgreement;
    }

    public ProductOfferingUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the productOffering is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ProductOfferingUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ProductOfferingUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ProductOfferingUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOfferingUpdate productOfferingUpdate = (ProductOfferingUpdate)o;
        return Objects.equals(this.description, productOfferingUpdate.description) && Objects.equals(this.isBundle, productOfferingUpdate.isBundle) && Objects.equals(this.isSellable, productOfferingUpdate.isSellable) && Objects.equals(this.lifecycleStatus, productOfferingUpdate.lifecycleStatus) && Objects.equals(this.name, productOfferingUpdate.name) && Objects.equals(this.statusReason, productOfferingUpdate.statusReason) && Objects.equals(this.version, productOfferingUpdate.version) && Objects.equals(this.agreement, productOfferingUpdate.agreement) && Objects.equals(this.attachment, productOfferingUpdate.attachment) && Objects.equals(this.bundledProductOffering, productOfferingUpdate.bundledProductOffering) && Objects.equals(this.category, productOfferingUpdate.category) && Objects.equals(this.channel, productOfferingUpdate.channel) && Objects.equals(this.marketSegment, productOfferingUpdate.marketSegment) && Objects.equals(this.place, productOfferingUpdate.place) && Objects.equals(this.prodSpecCharValueUse, productOfferingUpdate.prodSpecCharValueUse) && Objects.equals(this.productOfferingPrice, productOfferingUpdate.productOfferingPrice) && Objects.equals(this.productOfferingTerm, productOfferingUpdate.productOfferingTerm) && Objects.equals(this.productSpecification, productOfferingUpdate.productSpecification) && Objects.equals(this.resourceCandidate, productOfferingUpdate.resourceCandidate) && Objects.equals(this.serviceCandidate, productOfferingUpdate.serviceCandidate) && Objects.equals(this.serviceLevelAgreement, productOfferingUpdate.serviceLevelAgreement) && Objects.equals(this.validFor, productOfferingUpdate.validFor) && Objects.equals(this.baseType, productOfferingUpdate.baseType) && Objects.equals(this.schemaLocation, productOfferingUpdate.schemaLocation) && Objects.equals(this.type, productOfferingUpdate.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOfferingUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    isSellable: ").append(this.toIndentedString(this.isSellable)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    statusReason: ").append(this.toIndentedString(this.statusReason)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    bundledProductOffering: ").append(this.toIndentedString(this.bundledProductOffering)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    marketSegment: ").append(this.toIndentedString(this.marketSegment)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    prodSpecCharValueUse: ").append(this.toIndentedString(this.prodSpecCharValueUse)).append("\n");
        sb.append("    productOfferingPrice: ").append(this.toIndentedString(this.productOfferingPrice)).append("\n");
        sb.append("    productOfferingTerm: ").append(this.toIndentedString(this.productOfferingTerm)).append("\n");
        sb.append("    productSpecification: ").append(this.toIndentedString(this.productSpecification)).append("\n");
        sb.append("    resourceCandidate: ").append(this.toIndentedString(this.resourceCandidate)).append("\n");
        sb.append("    serviceCandidate: ").append(this.toIndentedString(this.serviceCandidate)).append("\n");
        sb.append("    serviceLevelAgreement: ").append(this.toIndentedString(this.serviceLevelAgreement)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

