/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.Quantity;
import org.springframework.validation.annotation.Validated;

@Schema(description="A condition under which a ProductOffering is made available to Customers. For instance, a productOffering can be offered with multiple commitment periods.")
@Validated
@Entity(name="ProductOfferingTerm")
public class ProductOfferingTerm
extends BaseEntity {
    @JsonProperty(value="duration")
    private Quantity duration = null;

    @Override
    public ProductOfferingTerm description(String description) {
        this.description = description;
        return this;
    }

    public ProductOfferingTerm duration(Quantity duration) {
        this.duration = duration;
        return this;
    }

    @Schema(description="Duration of the productOfferingTerm")
    @Valid
    public Quantity getDuration() {
        return this.duration;
    }

    public void setDuration(Quantity duration) {
        this.duration = duration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOfferingTerm productOfferingTerm = (ProductOfferingTerm)o;
        return Objects.equals(this.description, productOfferingTerm.description) && Objects.equals(this.name, productOfferingTerm.name) && Objects.equals(this.duration, productOfferingTerm.duration) && Objects.equals(this.validFor, productOfferingTerm.validFor) && Objects.equals(this.baseType, productOfferingTerm.baseType) && Objects.equals(this.schemaLocation, productOfferingTerm.schemaLocation) && Objects.equals(this.type, productOfferingTerm.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOfferingTerm {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

