/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.Quantity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pcm620.model.BundledProductOfferingPriceRelationship;
import org.etsi.osl.tmf.pcm620.model.ConstraintRef;
import org.etsi.osl.tmf.pcm620.model.Money;
import org.etsi.osl.tmf.pcm620.model.PlaceRef;
import org.etsi.osl.tmf.pcm620.model.PricingLogicAlgorithm;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPriceRelationship;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingTerm;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationCharacteristicValueUse;
import org.etsi.osl.tmf.pcm620.model.TaxItem;
import org.springframework.validation.annotation.Validated;

@Schema(description="Is based on both the basic cost to develop and produce products and the enterprises policy on revenue targets. This price may be further revised through discounting (productOfferPriceAlteration). The price, applied for a productOffering may also be influenced by the productOfferingTerm, the customer selected, eg: a productOffering can be offered with multiple terms, like commitment periods for the contract. The price may be influenced by this productOfferingTerm. A productOffering may be cheaper with a 24 month commitment than with a 12 month commitment. Skipped properties: id,href,lastUpdate")
@Validated
public class ProductOfferingPriceUpdate {
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="isBundle")
    protected Boolean isBundle = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="percentage")
    protected Float percentage = null;
    @JsonProperty(value="priceType")
    protected String priceType = null;
    @JsonProperty(value="recurringChargePeriodLength")
    protected Integer recurringChargePeriodLength = null;
    @JsonProperty(value="recurringChargePeriodType")
    protected String recurringChargePeriodType = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="bundledPopRelationship")
    @Valid
    protected List<BundledProductOfferingPriceRelationship> bundledPopRelationship = null;
    @JsonProperty(value="constraint")
    @Valid
    protected List<ConstraintRef> constraint = null;
    @JsonProperty(value="place")
    @Valid
    protected List<PlaceRef> place = null;
    @JsonProperty(value="popRelationship")
    @Valid
    protected List<ProductOfferingPriceRelationship> popRelationship = null;
    @JsonProperty(value="price")
    protected Money price = null;
    @JsonProperty(value="pricingLogicAlgorithm")
    @Valid
    protected List<PricingLogicAlgorithm> pricingLogicAlgorithm = null;
    @JsonProperty(value="prodSpecCharValueUse")
    @Valid
    protected List<ProductSpecificationCharacteristicValueUse> prodSpecCharValueUse = null;
    @JsonProperty(value="productOfferingTerm")
    @Valid
    protected List<ProductOfferingTerm> productOfferingTerm = null;
    @JsonProperty(value="tax")
    @Valid
    protected List<TaxItem> tax = null;
    @JsonProperty(value="unitOfMeasure")
    protected Quantity unitOfMeasure = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ProductOfferingPriceUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the productOfferingPrice")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProductOfferingPriceUpdate isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="A flag indicating if this ProductOfferingPrice is composite (bundle) or not")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ProductOfferingPriceUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="the lifecycle status of this ProductOfferingPrice")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ProductOfferingPriceUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the productOfferingPrice")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProductOfferingPriceUpdate percentage(Float percentage) {
        this.percentage = percentage;
        return this;
    }

    @Schema(description="Percentage to apply for ProductOfferPriceAlteration (Discount)")
    public Float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Float percentage) {
        this.percentage = percentage;
    }

    public ProductOfferingPriceUpdate priceType(String priceType) {
        this.priceType = priceType;
        return this;
    }

    @Schema(description="A category that describes the price, such as recurring, discount, allowance, penalty, and so forth.")
    public String getPriceType() {
        return this.priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public ProductOfferingPriceUpdate recurringChargePeriodLength(Integer recurringChargePeriodLength) {
        this.recurringChargePeriodLength = recurringChargePeriodLength;
        return this;
    }

    @Schema(description="the period of the recurring charge:  1, 2, ... .It sets to zero if it is not applicable")
    public Integer getRecurringChargePeriodLength() {
        return this.recurringChargePeriodLength;
    }

    public void setRecurringChargePeriodLength(Integer recurringChargePeriodLength) {
        this.recurringChargePeriodLength = recurringChargePeriodLength;
    }

    public ProductOfferingPriceUpdate recurringChargePeriodType(String recurringChargePeriodType) {
        this.recurringChargePeriodType = recurringChargePeriodType;
        return this;
    }

    @Schema(description="The period to repeat the application of the price Could be month, week...")
    public String getRecurringChargePeriodType() {
        return this.recurringChargePeriodType;
    }

    public void setRecurringChargePeriodType(String recurringChargePeriodType) {
        this.recurringChargePeriodType = recurringChargePeriodType;
    }

    public ProductOfferingPriceUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="ProductOffering version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ProductOfferingPriceUpdate bundledPopRelationship(List<BundledProductOfferingPriceRelationship> bundledPopRelationship) {
        this.bundledPopRelationship = bundledPopRelationship;
        return this;
    }

    public ProductOfferingPriceUpdate addBundledPopRelationshipItem(BundledProductOfferingPriceRelationship bundledPopRelationshipItem) {
        if (this.bundledPopRelationship == null) {
            this.bundledPopRelationship = new ArrayList<BundledProductOfferingPriceRelationship>();
        }
        this.bundledPopRelationship.add(bundledPopRelationshipItem);
        return this;
    }

    @Schema(description="this object represents a bundle relationship from a bundle product offering price (parent) to a simple product offering price (child). A simple product offering price may participate in more than one bundle relationship.")
    @Valid
    public List<BundledProductOfferingPriceRelationship> getBundledPopRelationship() {
        return this.bundledPopRelationship;
    }

    public void setBundledPopRelationship(List<BundledProductOfferingPriceRelationship> bundledPopRelationship) {
        this.bundledPopRelationship = bundledPopRelationship;
    }

    public ProductOfferingPriceUpdate constraint(List<ConstraintRef> constraint) {
        this.constraint = constraint;
        return this;
    }

    public ProductOfferingPriceUpdate addConstraintItem(ConstraintRef constraintItem) {
        if (this.constraint == null) {
            this.constraint = new ArrayList<ConstraintRef>();
        }
        this.constraint.add(constraintItem);
        return this;
    }

    @Schema(description="The Constraint resource represents a policy/rule applied to ProductOfferingPrice.")
    @Valid
    public List<ConstraintRef> getConstraint() {
        return this.constraint;
    }

    public void setConstraint(List<ConstraintRef> constraint) {
        this.constraint = constraint;
    }

    public ProductOfferingPriceUpdate place(List<PlaceRef> place) {
        this.place = place;
        return this;
    }

    public ProductOfferingPriceUpdate addPlaceItem(PlaceRef placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<PlaceRef>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="Place defines the places where the products are sold or delivered.")
    @Valid
    public List<PlaceRef> getPlace() {
        return this.place;
    }

    public void setPlace(List<PlaceRef> place) {
        this.place = place;
    }

    public ProductOfferingPriceUpdate popRelationship(List<ProductOfferingPriceRelationship> popRelationship) {
        this.popRelationship = popRelationship;
        return this;
    }

    public ProductOfferingPriceUpdate addPopRelationshipItem(ProductOfferingPriceRelationship popRelationshipItem) {
        if (this.popRelationship == null) {
            this.popRelationship = new ArrayList<ProductOfferingPriceRelationship>();
        }
        this.popRelationship.add(popRelationshipItem);
        return this;
    }

    @Schema(description="Product Offering Prices related to this Product Offering Price, for example a price alteration such as allowance or discount")
    @Valid
    public List<ProductOfferingPriceRelationship> getPopRelationship() {
        return this.popRelationship;
    }

    public void setPopRelationship(List<ProductOfferingPriceRelationship> popRelationship) {
        this.popRelationship = popRelationship;
    }

    public ProductOfferingPriceUpdate price(Money price) {
        this.price = price;
        return this;
    }

    @Schema(description="The amount of money that characterizes the price.")
    @Valid
    public Money getPrice() {
        return this.price;
    }

    public void setPrice(Money price) {
        this.price = price;
    }

    public ProductOfferingPriceUpdate pricingLogicAlgorithm(List<PricingLogicAlgorithm> pricingLogicAlgorithm) {
        this.pricingLogicAlgorithm = pricingLogicAlgorithm;
        return this;
    }

    public ProductOfferingPriceUpdate addPricingLogicAlgorithmItem(PricingLogicAlgorithm pricingLogicAlgorithmItem) {
        if (this.pricingLogicAlgorithm == null) {
            this.pricingLogicAlgorithm = new ArrayList<PricingLogicAlgorithm>();
        }
        this.pricingLogicAlgorithm.add(pricingLogicAlgorithmItem);
        return this;
    }

    @Schema(description="The PricingLogicAlgorithm entity represents an instantiation of an interface specification to external rating function (without a modeled behavior in SID). Some of the parameters of the interface definition may be already set (such as price per unit) and some may be gathered during the rating process from the event (such as call duration) or from ProductCharacteristicValues (such as assigned bandwidth).")
    @Valid
    public List<PricingLogicAlgorithm> getPricingLogicAlgorithm() {
        return this.pricingLogicAlgorithm;
    }

    public void setPricingLogicAlgorithm(List<PricingLogicAlgorithm> pricingLogicAlgorithm) {
        this.pricingLogicAlgorithm = pricingLogicAlgorithm;
    }

    public ProductOfferingPriceUpdate prodSpecCharValueUse(List<ProductSpecificationCharacteristicValueUse> prodSpecCharValueUse) {
        this.prodSpecCharValueUse = prodSpecCharValueUse;
        return this;
    }

    public ProductOfferingPriceUpdate addProdSpecCharValueUseItem(ProductSpecificationCharacteristicValueUse prodSpecCharValueUseItem) {
        if (this.prodSpecCharValueUse == null) {
            this.prodSpecCharValueUse = new ArrayList<ProductSpecificationCharacteristicValueUse>();
        }
        this.prodSpecCharValueUse.add(prodSpecCharValueUseItem);
        return this;
    }

    @Schema(description="A use of the ProductSpecificationCharacteristicValue by a ProductOfferingPrice to which additional properties (attributes) apply or override the properties of similar properties contained in ProductSpecificationCharacteristicValue. It should be noted that characteristics which their value(s) addressed by this object must exist in corresponding product specification. The available characteristic values for a ProductSpecificationCharacteristic in a Product specification can be modified at the ProductOffering and ProcuctOfferingPrice level. The list of values in ProductSpecificationCharacteristicValueUse is a strict subset of the list of values as defined in the corresponding product specification characteristics.")
    @Valid
    public List<ProductSpecificationCharacteristicValueUse> getProdSpecCharValueUse() {
        return this.prodSpecCharValueUse;
    }

    public void setProdSpecCharValueUse(List<ProductSpecificationCharacteristicValueUse> prodSpecCharValueUse) {
        this.prodSpecCharValueUse = prodSpecCharValueUse;
    }

    public ProductOfferingPriceUpdate productOfferingTerm(List<ProductOfferingTerm> productOfferingTerm) {
        this.productOfferingTerm = productOfferingTerm;
        return this;
    }

    public ProductOfferingPriceUpdate addProductOfferingTermItem(ProductOfferingTerm productOfferingTermItem) {
        if (this.productOfferingTerm == null) {
            this.productOfferingTerm = new ArrayList<ProductOfferingTerm>();
        }
        this.productOfferingTerm.add(productOfferingTermItem);
        return this;
    }

    @Schema(description="A list of conditions under which a ProductOfferingPrice is made available to Customers. For instance, a Product Offering Price can be offered with multiple commitment periods.")
    @Valid
    public List<ProductOfferingTerm> getProductOfferingTerm() {
        return this.productOfferingTerm;
    }

    public void setProductOfferingTerm(List<ProductOfferingTerm> productOfferingTerm) {
        this.productOfferingTerm = productOfferingTerm;
    }

    public ProductOfferingPriceUpdate tax(List<TaxItem> tax) {
        this.tax = tax;
        return this;
    }

    public ProductOfferingPriceUpdate addTaxItem(TaxItem taxItem) {
        if (this.tax == null) {
            this.tax = new ArrayList<TaxItem>();
        }
        this.tax.add(taxItem);
        return this;
    }

    @Schema(description="An amount of money levied on the price of a Product by a legislative body.")
    @Valid
    public List<TaxItem> getTax() {
        return this.tax;
    }

    public void setTax(List<TaxItem> tax) {
        this.tax = tax;
    }

    public ProductOfferingPriceUpdate unitOfMeasure(Quantity unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="A number and unit representing how many (for instance 1 dozen) of an ProductOffering is available at the offered price. Its meaning depends on the priceType. It could be a price, a rate, or a discount.")
    @Valid
    public Quantity getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(Quantity unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public ProductOfferingPriceUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the productOfferingPrice is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ProductOfferingPriceUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="the immediate base class type of this product offering")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ProductOfferingPriceUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="hyperlink reference to the schema describing this resource")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ProductOfferingPriceUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of this Product offering")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOfferingPriceUpdate productOfferingPriceUpdate = (ProductOfferingPriceUpdate)o;
        return Objects.equals(this.description, productOfferingPriceUpdate.description) && Objects.equals(this.isBundle, productOfferingPriceUpdate.isBundle) && Objects.equals(this.lifecycleStatus, productOfferingPriceUpdate.lifecycleStatus) && Objects.equals(this.name, productOfferingPriceUpdate.name) && Objects.equals(this.percentage, productOfferingPriceUpdate.percentage) && Objects.equals(this.priceType, productOfferingPriceUpdate.priceType) && Objects.equals(this.recurringChargePeriodLength, productOfferingPriceUpdate.recurringChargePeriodLength) && Objects.equals(this.recurringChargePeriodType, productOfferingPriceUpdate.recurringChargePeriodType) && Objects.equals(this.version, productOfferingPriceUpdate.version) && Objects.equals(this.bundledPopRelationship, productOfferingPriceUpdate.bundledPopRelationship) && Objects.equals(this.constraint, productOfferingPriceUpdate.constraint) && Objects.equals(this.place, productOfferingPriceUpdate.place) && Objects.equals(this.popRelationship, productOfferingPriceUpdate.popRelationship) && Objects.equals(this.price, productOfferingPriceUpdate.price) && Objects.equals(this.pricingLogicAlgorithm, productOfferingPriceUpdate.pricingLogicAlgorithm) && Objects.equals(this.prodSpecCharValueUse, productOfferingPriceUpdate.prodSpecCharValueUse) && Objects.equals(this.productOfferingTerm, productOfferingPriceUpdate.productOfferingTerm) && Objects.equals(this.tax, productOfferingPriceUpdate.tax) && Objects.equals(this.unitOfMeasure, productOfferingPriceUpdate.unitOfMeasure) && Objects.equals(this.validFor, productOfferingPriceUpdate.validFor) && Objects.equals(this.baseType, productOfferingPriceUpdate.baseType) && Objects.equals(this.schemaLocation, productOfferingPriceUpdate.schemaLocation) && Objects.equals(this.type, productOfferingPriceUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.isBundle, this.lifecycleStatus, this.name, this.percentage, this.priceType, this.recurringChargePeriodLength, this.recurringChargePeriodType, this.version, this.bundledPopRelationship, this.constraint, this.place, this.popRelationship, this.price, this.pricingLogicAlgorithm, this.prodSpecCharValueUse, this.productOfferingTerm, this.tax, this.unitOfMeasure, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOfferingPriceUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    priceType: ").append(this.toIndentedString(this.priceType)).append("\n");
        sb.append("    recurringChargePeriodLength: ").append(this.toIndentedString(this.recurringChargePeriodLength)).append("\n");
        sb.append("    recurringChargePeriodType: ").append(this.toIndentedString(this.recurringChargePeriodType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    bundledPopRelationship: ").append(this.toIndentedString(this.bundledPopRelationship)).append("\n");
        sb.append("    constraint: ").append(this.toIndentedString(this.constraint)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    popRelationship: ").append(this.toIndentedString(this.popRelationship)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    pricingLogicAlgorithm: ").append(this.toIndentedString(this.pricingLogicAlgorithm)).append("\n");
        sb.append("    prodSpecCharValueUse: ").append(this.toIndentedString(this.prodSpecCharValueUse)).append("\n");
        sb.append("    productOfferingTerm: ").append(this.toIndentedString(this.productOfferingTerm)).append("\n");
        sb.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

