/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Describes a non-composite relationship between product offering prices. For example one price might be an discount alteration for another price.")
@Validated
@Entity
public class ProductOfferingPriceRelationship
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;

    public ProductOfferingPriceRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the associated product offering price")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProductOfferingPriceRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="type of the relationship, for example override, discount, etc.")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOfferingPriceRelationship productOfferingPriceRelationship = (ProductOfferingPriceRelationship)o;
        return Objects.equals(this.id, productOfferingPriceRelationship.id) && Objects.equals(this.href, productOfferingPriceRelationship.href) && Objects.equals(this.name, productOfferingPriceRelationship.name) && Objects.equals(this.relationshipType, productOfferingPriceRelationship.relationshipType) && Objects.equals(this.baseType, productOfferingPriceRelationship.baseType) && Objects.equals(this.schemaLocation, productOfferingPriceRelationship.schemaLocation) && Objects.equals(this.type, productOfferingPriceRelationship.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOfferingPriceRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

