/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPriceUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="Is based on both the basic cost to develop and produce products and the enterprises policy on revenue targets. This price may be further revised through discounting (productOfferPriceAlteration). The price, applied for a productOffering may also be influenced by the productOfferingTerm, the customer selected, eg: a productOffering can be offered with multiple terms, like commitment periods for the contract. The price may be influenced by this productOfferingTerm. A productOffering may be cheaper with a 24 month commitment than with a 12 month commitment. Skipped properties: id,href")
@Validated
public class ProductOfferingPriceCreate
extends ProductOfferingPriceUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    public ProductOfferingPriceCreate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="the last update time of this ProductOfferingPrice")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOfferingPriceCreate productOfferingPriceCreate = (ProductOfferingPriceCreate)o;
        return Objects.equals(this.description, productOfferingPriceCreate.description) && Objects.equals(this.isBundle, productOfferingPriceCreate.isBundle) && Objects.equals(this.lastUpdate, productOfferingPriceCreate.lastUpdate) && Objects.equals(this.lifecycleStatus, productOfferingPriceCreate.lifecycleStatus) && Objects.equals(this.name, productOfferingPriceCreate.name) && Objects.equals(this.percentage, productOfferingPriceCreate.percentage) && Objects.equals(this.priceType, productOfferingPriceCreate.priceType) && Objects.equals(this.recurringChargePeriodLength, productOfferingPriceCreate.recurringChargePeriodLength) && Objects.equals(this.recurringChargePeriodType, productOfferingPriceCreate.recurringChargePeriodType) && Objects.equals(this.version, productOfferingPriceCreate.version) && Objects.equals(this.bundledPopRelationship, productOfferingPriceCreate.bundledPopRelationship) && Objects.equals(this.constraint, productOfferingPriceCreate.constraint) && Objects.equals(this.place, productOfferingPriceCreate.place) && Objects.equals(this.popRelationship, productOfferingPriceCreate.popRelationship) && Objects.equals(this.price, productOfferingPriceCreate.price) && Objects.equals(this.pricingLogicAlgorithm, productOfferingPriceCreate.pricingLogicAlgorithm) && Objects.equals(this.prodSpecCharValueUse, productOfferingPriceCreate.prodSpecCharValueUse) && Objects.equals(this.productOfferingTerm, productOfferingPriceCreate.productOfferingTerm) && Objects.equals(this.tax, productOfferingPriceCreate.tax) && Objects.equals(this.unitOfMeasure, productOfferingPriceCreate.unitOfMeasure) && Objects.equals(this.validFor, productOfferingPriceCreate.validFor) && Objects.equals(this.baseType, productOfferingPriceCreate.baseType) && Objects.equals(this.schemaLocation, productOfferingPriceCreate.schemaLocation) && Objects.equals(this.type, productOfferingPriceCreate.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOfferingPriceCreate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    priceType: ").append(this.toIndentedString(this.priceType)).append("\n");
        sb.append("    recurringChargePeriodLength: ").append(this.toIndentedString(this.recurringChargePeriodLength)).append("\n");
        sb.append("    recurringChargePeriodType: ").append(this.toIndentedString(this.recurringChargePeriodType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    bundledPopRelationship: ").append(this.toIndentedString(this.bundledPopRelationship)).append("\n");
        sb.append("    constraint: ").append(this.toIndentedString(this.constraint)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    popRelationship: ").append(this.toIndentedString(this.popRelationship)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    pricingLogicAlgorithm: ").append(this.toIndentedString(this.pricingLogicAlgorithm)).append("\n");
        sb.append("    prodSpecCharValueUse: ").append(this.toIndentedString(this.prodSpecCharValueUse)).append("\n");
        sb.append("    productOfferingTerm: ").append(this.toIndentedString(this.productOfferingTerm)).append("\n");
        sb.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

