/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.am651.model.AgreementRef;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.pcm620.model.BundledProductOffering;
import org.etsi.osl.tmf.pcm620.model.CategoryRef;
import org.etsi.osl.tmf.pcm620.model.ChannelRef;
import org.etsi.osl.tmf.pcm620.model.MarketSegmentRef;
import org.etsi.osl.tmf.pcm620.model.PlaceRef;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPriceRef;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingTerm;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationCharacteristicValueUse;
import org.etsi.osl.tmf.pcm620.model.ProductSpecificationRef;
import org.etsi.osl.tmf.pcm620.model.ResourceCandidateRef;
import org.etsi.osl.tmf.pcm620.model.SLARef;
import org.etsi.osl.tmf.pcm620.model.ServiceCandidateRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Represents entities that are orderable from the provider of the catalog, this resource includes pricing information.")
@Validated
@Entity(name="ProductOffering")
@Table(name="ProductOffering")
public class ProductOffering
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="isBundle")
    private Boolean isBundle = null;
    @JsonProperty(value="isSellable")
    private Boolean isSellable = null;
    @JsonProperty(value="statusReason")
    private String statusReason = null;
    @JsonProperty(value="agreement")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AgreementRef> agreement = new HashSet<AgreementRef>();
    @JsonProperty(value="attachment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AttachmentRefOrValue> attachment = new HashSet<AttachmentRefOrValue>();
    @JsonProperty(value="bundledProductOffering")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<BundledProductOffering> bundledProductOffering = new HashSet<BundledProductOffering>();
    @JsonProperty(value="category")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<CategoryRef> category = new HashSet<CategoryRef>();
    @JsonProperty(value="channel")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ChannelRef> channel = new HashSet<ChannelRef>();
    @JsonProperty(value="marketSegment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<MarketSegmentRef> marketSegment = new HashSet<MarketSegmentRef>();
    @JsonProperty(value="place")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<PlaceRef> place = new HashSet<PlaceRef>();
    @JsonProperty(value="prodSpecCharValueUse")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductSpecificationCharacteristicValueUse> prodSpecCharValueUse = new HashSet<ProductSpecificationCharacteristicValueUse>();
    @JsonProperty(value="productOfferingPrice")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductOfferingPriceRef> productOfferingPrice = new HashSet<ProductOfferingPriceRef>();
    @JsonProperty(value="productOfferingTerm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ProductOfferingTerm> productOfferingTerm = new HashSet<ProductOfferingTerm>();
    @JsonProperty(value="productSpecification")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(referencedColumnName="uuid")
    private ProductSpecificationRef productSpecification = null;
    @JsonProperty(value="resourceCandidate")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(referencedColumnName="uuid")
    private ResourceCandidateRef resourceCandidate = null;
    @JsonProperty(value="serviceCandidate")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(referencedColumnName="uuid")
    private ServiceCandidateRef serviceCandidate = null;
    @JsonProperty(value="serviceLevelAgreement")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(referencedColumnName="uuid")
    private SLARef serviceLevelAgreement = null;

    public ProductOffering id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the productOffering")
    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public ProductOffering isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="isBundle determines whether a productOffering represents a single productOffering (false), or a bundle of productOfferings (true).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ProductOffering isSellable(Boolean isSellable) {
        this.isSellable = isSellable;
        return this;
    }

    @Schema(description="A flag indicating if this product offer can be sold stand-alone for sale or not. If this flag is false it indicates that the offer can only be sold within a bundle.")
    public Boolean isIsSellable() {
        return this.isSellable;
    }

    public void setIsSellable(Boolean isSellable) {
        this.isSellable = isSellable;
    }

    @Schema(description="A string providing a complementary information on the value of the lifecycle status attribute.")
    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public ProductOffering agreement(Set<AgreementRef> agreement) {
        this.agreement = agreement;
        return this;
    }

    public ProductOffering addAgreementItem(AgreementRef agreementItem) {
        if (this.agreement == null) {
            this.agreement = new HashSet<AgreementRef>();
        }
        this.agreement.add(agreementItem);
        return this;
    }

    @Schema(description="An agreement represents a contract or arrangement, either written or verbal and sometimes enforceable by law, such as a service level agreement or a customer price agreement. An agreement involves a number of other business entities, such as products, services, and resources and/or their specifications.")
    @Valid
    public Set<AgreementRef> getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Set<AgreementRef> agreement) {
        this.agreement = agreement;
    }

    public ProductOffering attachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ProductOffering addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new HashSet<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="Complements the description of an element (for instance a product) through video, pictures...")
    @Valid
    public Set<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public ProductOffering bundledProductOffering(Set<BundledProductOffering> bundledProductOffering) {
        this.bundledProductOffering = bundledProductOffering;
        return this;
    }

    public ProductOffering addBundledProductOfferingItem(BundledProductOffering bundledProductOfferingItem) {
        if (this.bundledProductOffering == null) {
            this.bundledProductOffering = new HashSet<BundledProductOffering>();
        }
        this.bundledProductOffering.add(bundledProductOfferingItem);
        return this;
    }

    @Schema(description="A type of ProductOffering that belongs to a grouping of ProductOfferings made available to the market. It inherits of all attributes of ProductOffering.")
    @Valid
    public Set<BundledProductOffering> getBundledProductOffering() {
        return this.bundledProductOffering;
    }

    public void setBundledProductOffering(Set<BundledProductOffering> bundledProductOffering) {
        this.bundledProductOffering = bundledProductOffering;
    }

    public ProductOffering category(Set<CategoryRef> category) {
        this.category = category;
        return this;
    }

    public ProductOffering addCategoryItem(CategoryRef categoryItem) {
        if (this.category == null) {
            this.category = new HashSet<CategoryRef>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Schema(description="The category resource is used to group product offerings, service and resource candidates in logical containers. Categories can contain other categories and/or product offerings, resource or service candidates.")
    @Valid
    public Set<CategoryRef> getCategory() {
        return this.category;
    }

    public void setCategory(Set<CategoryRef> category) {
        this.category = category;
    }

    public ProductOffering channel(Set<ChannelRef> channel) {
        this.channel = channel;
        return this;
    }

    public ProductOffering addChannelItem(ChannelRef channelItem) {
        if (this.channel == null) {
            this.channel = new HashSet<ChannelRef>();
        }
        this.channel.add(channelItem);
        return this;
    }

    @Schema(description="The channel defines the channel for selling product offerings.")
    @Valid
    public Set<ChannelRef> getChannel() {
        return this.channel;
    }

    public void setChannel(Set<ChannelRef> channel) {
        this.channel = channel;
    }

    public ProductOffering marketSegment(Set<MarketSegmentRef> marketSegment) {
        this.marketSegment = marketSegment;
        return this;
    }

    public ProductOffering addMarketSegmentItem(MarketSegmentRef marketSegmentItem) {
        if (this.marketSegment == null) {
            this.marketSegment = new HashSet<MarketSegmentRef>();
        }
        this.marketSegment.add(marketSegmentItem);
        return this;
    }

    @Schema(description="provides references to the corresponding market segment as target of product offerings. A market segment is grouping of Parties, GeographicAreas, SalesChannels, and so forth.")
    @Valid
    public Set<MarketSegmentRef> getMarketSegment() {
        return this.marketSegment;
    }

    public void setMarketSegment(Set<MarketSegmentRef> marketSegment) {
        this.marketSegment = marketSegment;
    }

    public ProductOffering place(Set<PlaceRef> place) {
        this.place = place;
        return this;
    }

    public ProductOffering addPlaceItem(PlaceRef placeItem) {
        if (this.place == null) {
            this.place = new HashSet<PlaceRef>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="Place defines the places where the products are sold or delivered.")
    @Valid
    public Set<PlaceRef> getPlace() {
        return this.place;
    }

    public void setPlace(Set<PlaceRef> place) {
        this.place = place;
    }

    public ProductOffering prodSpecCharValueUse(Set<ProductSpecificationCharacteristicValueUse> prodSpecCharValueUse) {
        this.prodSpecCharValueUse = prodSpecCharValueUse;
        return this;
    }

    public ProductOffering addProdSpecCharValueUseItem(ProductSpecificationCharacteristicValueUse prodSpecCharValueUseItem) {
        if (this.prodSpecCharValueUse == null) {
            this.prodSpecCharValueUse = new HashSet<ProductSpecificationCharacteristicValueUse>();
        }
        this.prodSpecCharValueUse.add(prodSpecCharValueUseItem);
        return this;
    }

    @Schema(description="A use of the ProductSpecificationCharacteristicValue by a ProductOffering to which additional properties (attributes) apply or override the properties of similar properties contained in ProductSpecificationCharacteristicValue. It should be noted that characteristics which their value(s) addressed by this object must exist in corresponding product specification. The available characteristic values for a ProductSpecificationCharacteristic in a Product specification can be modified at the ProductOffering level. For example, a characteristic 'Color' might have values White, Blue, Green, and Red. But, the list of values can be restricted to e.g. White and Blue in an associated product offering. It should be noted that the list of values in 'ProductSpecificationCharacteristicValueUse' is a strict subset of the list of values as defined in the corresponding product specification characteristics.")
    @Valid
    public Set<ProductSpecificationCharacteristicValueUse> getProdSpecCharValueUse() {
        return this.prodSpecCharValueUse;
    }

    public void setProdSpecCharValueUse(Set<ProductSpecificationCharacteristicValueUse> prodSpecCharValueUse) {
        this.prodSpecCharValueUse = prodSpecCharValueUse;
    }

    public ProductOffering productOfferingPrice(Set<ProductOfferingPriceRef> productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
        return this;
    }

    public ProductOffering addProductOfferingPriceItem(ProductOfferingPriceRef productOfferingPriceItem) {
        if (this.productOfferingPrice == null) {
            this.productOfferingPrice = new HashSet<ProductOfferingPriceRef>();
        }
        this.productOfferingPrice.add(productOfferingPriceItem);
        return this;
    }

    @Schema(description="An amount, usually of money, that is asked for or allowed when a ProductOffering is bought, rented, or leased. The price is valid for a defined period of time and may not represent the actual price paid by a customer.")
    @Valid
    public Set<ProductOfferingPriceRef> getProductOfferingPrice() {
        return this.productOfferingPrice;
    }

    public void setProductOfferingPrice(Set<ProductOfferingPriceRef> productOfferingPrice) {
        this.productOfferingPrice = productOfferingPrice;
    }

    public ProductOffering productOfferingTerm(Set<ProductOfferingTerm> productOfferingTerm) {
        this.productOfferingTerm = productOfferingTerm;
        return this;
    }

    public ProductOffering addProductOfferingTermItem(ProductOfferingTerm productOfferingTermItem) {
        if (this.productOfferingTerm == null) {
            this.productOfferingTerm = new HashSet<ProductOfferingTerm>();
        }
        this.productOfferingTerm.add(productOfferingTermItem);
        return this;
    }

    @Schema(description="A condition under which a ProductOffering is made available to Customers. For instance, a productOffering can be offered with multiple commitment periods.")
    @Valid
    public Set<ProductOfferingTerm> getProductOfferingTerm() {
        return this.productOfferingTerm;
    }

    public void setProductOfferingTerm(Set<ProductOfferingTerm> productOfferingTerm) {
        this.productOfferingTerm = productOfferingTerm;
    }

    public ProductOffering productSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
        return this;
    }

    @Schema(description="A ProductSpecification is a detailed description of a tangible or intangible object made available externally in the form of a ProductOffering to customers or other parties playing a party role.")
    @Valid
    public ProductSpecificationRef getProductSpecification() {
        return this.productSpecification;
    }

    public void setProductSpecification(ProductSpecificationRef productSpecification) {
        this.productSpecification = productSpecification;
    }

    public ProductOffering resourceCandidate(ResourceCandidateRef resourceCandidate) {
        this.resourceCandidate = resourceCandidate;
        return this;
    }

    @Schema(description="A resource candidate is an entity that makes a ResourceSpecification available to a catalog.")
    @Valid
    public ResourceCandidateRef getResourceCandidate() {
        return this.resourceCandidate;
    }

    public void setResourceCandidate(ResourceCandidateRef resourceCandidate) {
        this.resourceCandidate = resourceCandidate;
    }

    public ProductOffering serviceCandidate(ServiceCandidateRef serviceCandidate) {
        this.serviceCandidate = serviceCandidate;
        return this;
    }

    @Schema(description="ServiceCandidate is an entity that makes a ServiceSpecification available to a catalog.")
    @Valid
    public ServiceCandidateRef getServiceCandidate() {
        return this.serviceCandidate;
    }

    public void setServiceCandidate(ServiceCandidateRef serviceCandidate) {
        this.serviceCandidate = serviceCandidate;
    }

    public ProductOffering serviceLevelAgreement(SLARef serviceLevelAgreement) {
        this.serviceLevelAgreement = serviceLevelAgreement;
        return this;
    }

    @Schema(description="A service level agreement (SLA) is a type of agreement that represents a formal negotiated agreement between two parties designed to create a common understanding about products, services, priorities, responsibilities, and so forth. The SLA is a set of appropriate procedures and targets formally or informally agreed between parties in order to achieve and maintain specified Quality of Service.")
    @Valid
    public SLARef getServiceLevelAgreement() {
        return this.serviceLevelAgreement;
    }

    public void setServiceLevelAgreement(SLARef serviceLevelAgreement) {
        this.serviceLevelAgreement = serviceLevelAgreement;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOffering productOffering = (ProductOffering)o;
        return Objects.equals(this.id, productOffering.id) && Objects.equals(this.href, productOffering.href) && Objects.equals(this.description, productOffering.description) && Objects.equals(this.isBundle, productOffering.isBundle) && Objects.equals(this.isSellable, productOffering.isSellable) && Objects.equals(this.lastUpdate, productOffering.lastUpdate) && Objects.equals(this.lifecycleStatus, productOffering.lifecycleStatus) && Objects.equals(this.name, productOffering.name) && Objects.equals(this.statusReason, productOffering.statusReason) && Objects.equals(this.version, productOffering.version) && Objects.equals(this.agreement, productOffering.agreement) && Objects.equals(this.attachment, productOffering.attachment) && Objects.equals(this.bundledProductOffering, productOffering.bundledProductOffering) && Objects.equals(this.category, productOffering.category) && Objects.equals(this.channel, productOffering.channel) && Objects.equals(this.marketSegment, productOffering.marketSegment) && Objects.equals(this.place, productOffering.place) && Objects.equals(this.prodSpecCharValueUse, productOffering.prodSpecCharValueUse) && Objects.equals(this.productOfferingPrice, productOffering.productOfferingPrice) && Objects.equals(this.productOfferingTerm, productOffering.productOfferingTerm) && Objects.equals(this.productSpecification, productOffering.productSpecification) && Objects.equals(this.resourceCandidate, productOffering.resourceCandidate) && Objects.equals(this.serviceCandidate, productOffering.serviceCandidate) && Objects.equals(this.serviceLevelAgreement, productOffering.serviceLevelAgreement) && Objects.equals(this.validFor, productOffering.validFor) && Objects.equals(this.baseType, productOffering.baseType) && Objects.equals(this.schemaLocation, productOffering.schemaLocation) && Objects.equals(this.type, productOffering.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductOffering {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    isSellable: ").append(this.toIndentedString(this.isSellable)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    statusReason: ").append(this.toIndentedString(this.statusReason)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    bundledProductOffering: ").append(this.toIndentedString(this.bundledProductOffering)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    marketSegment: ").append(this.toIndentedString(this.marketSegment)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    prodSpecCharValueUse: ").append(this.toIndentedString(this.prodSpecCharValueUse)).append("\n");
        sb.append("    productOfferingPrice: ").append(this.toIndentedString(this.productOfferingPrice)).append("\n");
        sb.append("    productOfferingTerm: ").append(this.toIndentedString(this.productOfferingTerm)).append("\n");
        sb.append("    productSpecification: ").append(this.toIndentedString(this.productSpecification)).append("\n");
        sb.append("    resourceCandidate: ").append(this.toIndentedString(this.resourceCandidate)).append("\n");
        sb.append("    serviceCandidate: ").append(this.toIndentedString(this.serviceCandidate)).append("\n");
        sb.append("    serviceLevelAgreement: ").append(this.toIndentedString(this.serviceLevelAgreement)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Object findCharacteristicByName(String aname) {
        for (ProductSpecificationCharacteristicValueUse ssci : this.prodSpecCharValueUse) {
            if (ssci.getName() == null || !ssci.getName().equals(aname)) continue;
            return ssci;
        }
        return null;
    }
}

