/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="The PricingLogicAlgorithm entity represents an instantiation of an interface specification to external rating function (without a modeled bahavior in SID). Some of the parameters of the interface definiition may be already set (such as price per unit) and some may be gathered during the rating process from the event (such as call duration) or from ProductCharacteristicValues (such as assigned bandwidth)")
@Validated
@Entity
public class PricingLogicAlgorithm
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="plaSpecId")
    private String plaSpecId = null;

    public PricingLogicAlgorithm id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="unique id of the PricingLogicAlgorithm")
    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public PricingLogicAlgorithm plaSpecId(String plaSpecId) {
        this.plaSpecId = plaSpecId;
        return this;
    }

    @Schema(description="id of corresponding PricingLogicAlgorithm specification")
    public String getPlaSpecId() {
        return this.plaSpecId;
    }

    public void setPlaSpecId(String plaSpecId) {
        this.plaSpecId = plaSpecId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricingLogicAlgorithm pricingLogicAlgorithm = (PricingLogicAlgorithm)o;
        return Objects.equals(this.id, pricingLogicAlgorithm.id) && Objects.equals(this.href, pricingLogicAlgorithm.href) && Objects.equals(this.description, pricingLogicAlgorithm.description) && Objects.equals(this.name, pricingLogicAlgorithm.name) && Objects.equals(this.plaSpecId, pricingLogicAlgorithm.plaSpecId) && Objects.equals(this.validFor, pricingLogicAlgorithm.validFor) && Objects.equals(this.baseType, pricingLogicAlgorithm.baseType) && Objects.equals(this.schemaLocation, pricingLogicAlgorithm.schemaLocation) && Objects.equals(this.type, pricingLogicAlgorithm.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricingLogicAlgorithm {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plaSpecId: ").append(this.toIndentedString(this.plaSpecId)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

