/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Constraint reference. The Constraint resource represents a policy/rule applied to an entity or entity spec.")
@Validated
@Entity
public class ConstraintRef
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public ConstraintRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="reference id to the target constraint")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConstraintRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The (class) type of the referred constraint")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintRef constraintRef = (ConstraintRef)o;
        return Objects.equals(this.id, constraintRef.id) && Objects.equals(this.href, constraintRef.href) && Objects.equals(this.name, constraintRef.name) && Objects.equals(this.version, constraintRef.version) && Objects.equals(this.baseType, constraintRef.baseType) && Objects.equals(this.schemaLocation, constraintRef.schemaLocation) && Objects.equals(this.type, constraintRef.type) && Objects.equals(this.referredType, constraintRef.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConstraintRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

