/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="The channel to which the resource reference to. e.g. channel for selling product offerings, channel for opening a trouble ticket etc..")
@Validated
@Entity(name="ChannelRef")
public class ChannelRef
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    @Schema(description="Unique identifier of a related entity.")
    @NotNull
    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public ChannelRef href(String href) {
        this.href = href;
        return this;
    }

    public ChannelRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelRef channelRef = (ChannelRef)o;
        return Objects.equals(this.id, channelRef.id) && Objects.equals(this.href, channelRef.href) && Objects.equals(this.name, channelRef.name) && Objects.equals(this.baseType, channelRef.baseType) && Objects.equals(this.schemaLocation, channelRef.schemaLocation) && Objects.equals(this.type, channelRef.type) && Objects.equals(this.referredType, channelRef.referredType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.name, this.baseType, this.schemaLocation, this.type, this.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChannelRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

