/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pcm620.model.CategoryRef;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The category resource is used to group product offerings, service and resource candidates in logical containers. Categories can contain other categories and/or product offerings, resource or service candidates. Skipped properties: id,href,lastUpdate")
@Validated
public class CategoryUpdate {
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="isRoot")
    protected Boolean isRoot = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="parentId")
    protected String parentId = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="productOffering")
    @Valid
    protected List<ProductOfferingRef> productOffering = null;
    @JsonProperty(value="subCategory")
    @Valid
    protected List<CategoryRef> subCategory = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public CategoryUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the category")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CategoryUpdate isRoot(Boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    @Schema(description="If true, this Boolean indicates that the category is a root of categories")
    public Boolean isIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(Boolean isRoot) {
        this.isRoot = isRoot;
    }

    public CategoryUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public CategoryUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the category")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CategoryUpdate parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(description="Unique identifier of the parent category")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public CategoryUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Category version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public CategoryUpdate productOffering(List<ProductOfferingRef> productOffering) {
        this.productOffering = productOffering;
        return this;
    }

    public CategoryUpdate addProductOfferingItem(ProductOfferingRef productOfferingItem) {
        if (this.productOffering == null) {
            this.productOffering = new ArrayList<ProductOfferingRef>();
        }
        this.productOffering.add(productOfferingItem);
        return this;
    }

    @Schema(description="A product offering represents entities that are orderable from the provider of the catalog, this resource includes pricing information.")
    @Valid
    public List<ProductOfferingRef> getProductOffering() {
        return this.productOffering;
    }

    public void setProductOffering(List<ProductOfferingRef> productOffering) {
        this.productOffering = productOffering;
    }

    public CategoryUpdate subCategory(List<CategoryRef> subCategory) {
        this.subCategory = subCategory;
        return this;
    }

    public CategoryUpdate addSubCategoryItem(CategoryRef subCategoryItem) {
        if (this.subCategory == null) {
            this.subCategory = new ArrayList<CategoryRef>();
        }
        this.subCategory.add(subCategoryItem);
        return this;
    }

    @Schema(description="The category resource is used to group product offerings, service and resource candidates in logical containers. Categories can contain other (sub-)categories and/or product offerings.")
    @Valid
    public List<CategoryRef> getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(List<CategoryRef> subCategory) {
        this.subCategory = subCategory;
    }

    public CategoryUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the category is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public CategoryUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public CategoryUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public CategoryUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryUpdate categoryUpdate = (CategoryUpdate)o;
        return Objects.equals(this.description, categoryUpdate.description) && Objects.equals(this.isRoot, categoryUpdate.isRoot) && Objects.equals(this.lifecycleStatus, categoryUpdate.lifecycleStatus) && Objects.equals(this.name, categoryUpdate.name) && Objects.equals(this.parentId, categoryUpdate.parentId) && Objects.equals(this.version, categoryUpdate.version) && Objects.equals(this.productOffering, categoryUpdate.productOffering) && Objects.equals(this.subCategory, categoryUpdate.subCategory) && Objects.equals(this.validFor, categoryUpdate.validFor) && Objects.equals(this.baseType, categoryUpdate.baseType) && Objects.equals(this.schemaLocation, categoryUpdate.schemaLocation) && Objects.equals(this.type, categoryUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.isRoot, this.lifecycleStatus, this.name, this.parentId, this.version, this.productOffering, this.subCategory, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategoryUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    productOffering: ").append(this.toIndentedString(this.productOffering)).append("\n");
        sb.append("    subCategory: ").append(this.toIndentedString(this.subCategory)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

