/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.pcm620.model.CategoryUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="The category resource is used to group product offerings, service and resource candidates in logical containers. Categories can contain other categories and/or product offerings, resource or service candidates. Skipped properties: id,href")
@Validated
public class CategoryCreate
extends CategoryUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    public CategoryCreate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryCreate categoryCreate = (CategoryCreate)o;
        return Objects.equals(this.description, categoryCreate.description) && Objects.equals(this.isRoot, categoryCreate.isRoot) && Objects.equals(this.lastUpdate, categoryCreate.lastUpdate) && Objects.equals(this.lifecycleStatus, categoryCreate.lifecycleStatus) && Objects.equals(this.name, categoryCreate.name) && Objects.equals(this.parentId, categoryCreate.parentId) && Objects.equals(this.version, categoryCreate.version) && Objects.equals(this.productOffering, categoryCreate.productOffering) && Objects.equals(this.subCategory, categoryCreate.subCategory) && Objects.equals(this.validFor, categoryCreate.validFor) && Objects.equals(this.baseType, categoryCreate.baseType) && Objects.equals(this.schemaLocation, categoryCreate.schemaLocation) && Objects.equals(this.type, categoryCreate.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategoryCreate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    productOffering: ").append(this.toIndentedString(this.productOffering)).append("\n");
        sb.append("    subCategory: ").append(this.toIndentedString(this.subCategory)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

