/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.pcm620.model.CategoryRef;
import org.etsi.osl.tmf.pcm620.model.ProductOffering;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The category resource is used to group product offerings, service and resource candidates in logical containers. Categories can contain other categories and/or product offerings, resource or service candidates.")
@Validated
@Entity(name="ProductCategory")
@Table(name="ProductCategory")
public class Category
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="isRoot")
    private Boolean isRoot = null;
    @JsonProperty(value="parentId")
    private String parentId = null;
    @ManyToMany(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinTable
    @JsonIgnore
    private Set<ProductOffering> productOffObj = new HashSet<ProductOffering>();
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinTable
    @JsonIgnore
    private Set<Category> subCategoryObj = new HashSet<Category>();

    public Category id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the category")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public Category isRoot(Boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    @Schema(description="If true, this Boolean indicates that the category is a root of categories")
    public Boolean isIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(Boolean isRoot) {
        this.isRoot = isRoot;
    }

    public Category parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(description="Unique identifier of the parent category")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Schema(description="A product offering represents entities that are orderable from the provider of the catalog, this resource includes pricing information.")
    @Valid
    @JsonProperty(value="productOffering")
    public List<ProductOfferingRef> getProductOfferingRefs() {
        ArrayList<ProductOfferingRef> scref = new ArrayList<ProductOfferingRef>();
        for (ProductOffering sc : this.productOffObj) {
            ProductOfferingRef scr = new ProductOfferingRef();
            scr.setId(sc.getId());
            scr.setName(sc.getName());
            scr.setBaseType(ProductOfferingRef.class.getName());
            scref.add(scr);
        }
        return scref;
    }

    @JsonIgnore
    public Set<ProductOffering> getProductOfferingObj() {
        return this.productOffObj;
    }

    @Schema(description="List of child categories in the tree for in this category")
    @Transient
    @JsonProperty(value="subCategory")
    @Valid
    public List<CategoryRef> getCategoryRefs() {
        ArrayList<CategoryRef> category = new ArrayList<CategoryRef>();
        for (Category sCategory : this.subCategoryObj) {
            CategoryRef scr = new CategoryRef();
            scr.setId(sCategory.getId());
            scr.setName(sCategory.getName());
            scr.setBaseType(CategoryRef.class.getName());
            category.add(scr);
        }
        return category;
    }

    @JsonProperty(value="subCategory")
    public void setCategoryObj(List<CategoryRef> alist) {
        this.subCategoryObj.clear();
        for (CategoryRef categoryRef : alist) {
            Category sc = new Category();
            sc.setUuid(categoryRef.getId());
            sc.setName(categoryRef.getName());
            sc.setBaseType(categoryRef.getBaseType());
            this.subCategoryObj.add(sc);
        }
    }

    public Set<Category> getCategoryObj() {
        return this.subCategoryObj;
    }

    public void setCategoryObj(Set<Category> categoryObj) {
        this.subCategoryObj = categoryObj;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Category category = (Category)o;
        return Objects.equals(this.id, category.id) && Objects.equals(this.href, category.href) && Objects.equals(this.description, category.description) && Objects.equals(this.isRoot, category.isRoot) && Objects.equals(this.lastUpdate, category.lastUpdate) && Objects.equals(this.lifecycleStatus, category.lifecycleStatus) && Objects.equals(this.name, category.name) && Objects.equals(this.parentId, category.parentId) && Objects.equals(this.version, category.version) && Objects.equals(this.productOffObj, category.productOffObj) && Objects.equals(this.subCategoryObj, category.subCategoryObj) && Objects.equals(this.validFor, category.validFor) && Objects.equals(this.baseType, category.baseType) && Objects.equals(this.schemaLocation, category.schemaLocation) && Objects.equals(this.type, category.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Category {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    productOffering: ").append(this.toIndentedString(this.productOffObj)).append("\n");
        sb.append("    subCategory: ").append(this.toIndentedString(this.subCategoryObj)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

