/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.pcm620.model.Category;
import org.etsi.osl.tmf.pcm620.model.CategoryRef;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="A collection of Product Offerings, intended for a specific DistributionChannel, enhanced with additional information such as SLA parameters, invoicing and shipping details")
@Validated
@Entity(name="ProductCatalog")
@Table(name="ProductCatalog")
public class Catalog
extends BaseEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="catalogType")
    private String catalogType = null;
    @ManyToMany(cascade={CascadeType.DETACH})
    @JoinTable
    @JsonIgnore
    private Set<Category> categoryObj = new HashSet<Category>();
    @Transient
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;

    public Catalog id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="List of  categories associated with this catalog")
    @Transient
    @JsonProperty(value="category")
    @Valid
    public List<CategoryRef> getCategoryRefs() {
        ArrayList<CategoryRef> category = new ArrayList<CategoryRef>();
        for (Category Category2 : this.categoryObj) {
            CategoryRef scr = new CategoryRef();
            scr.setId(Category2.getId());
            scr.setName(Category2.getName());
            scr.setBaseType(CategoryRef.class.getName());
            category.add(scr);
        }
        return category;
    }

    public void setCategoryRefs(List<CategoryRef> crefs) {
        for (CategoryRef CategoryRef2 : crefs) {
            Category e = new Category();
            e.setUuid(CategoryRef2.getId());
            e.setName(CategoryRef2.getName());
            this.categoryObj.add(e);
        }
    }

    public Set<Category> getCategoryObj() {
        return this.categoryObj;
    }

    public void setCategoryObj(Set<Category> categoryObj) {
        this.categoryObj = categoryObj;
    }

    @Schema(description="Unique identifier of the Catalog")
    public String getId() {
        return this.uuid;
    }

    public Catalog catalogType(String catalogType) {
        this.catalogType = catalogType;
        return this;
    }

    @Schema(description="Indicates if the catalog is a product, service or resource catalog")
    public String getCatalogType() {
        return this.catalogType;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public Catalog relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Catalog addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="List of parties involved in this catalog")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Catalog catalog = (Catalog)o;
        return Objects.equals(this.id, catalog.id) && Objects.equals(this.href, catalog.href) && Objects.equals(this.catalogType, catalog.catalogType) && Objects.equals(this.description, catalog.description) && Objects.equals(this.lastUpdate, catalog.lastUpdate) && Objects.equals(this.lifecycleStatus, catalog.lifecycleStatus) && Objects.equals(this.name, catalog.name) && Objects.equals(this.version, catalog.version) && Objects.equals(this.getCategoryRefs(), catalog.getCategoryRefs()) && Objects.equals(this.relatedParty, catalog.relatedParty) && Objects.equals(this.validFor, catalog.validFor) && Objects.equals(this.baseType, catalog.baseType) && Objects.equals(this.schemaLocation, catalog.schemaLocation) && Objects.equals(this.type, catalog.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Catalog {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    catalogType: ").append(this.toIndentedString(this.catalogType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.getCategoryRefs())).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void addCategory(Category servcat) {
        if (!this.categoryObj.contains(servcat)) {
            this.categoryObj.add(servcat);
        }
    }
}

