/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="A type of ProductSpecification that belongs to a grouping of ProductSpecifications made available to the market. It inherits of all attributes of ProductSpecification.")
@Validated
@Entity
public class BundledProductSpecification
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="lifecycleStatus")
    private String lifecycleStatus = null;

    public BundledProductSpecification() {
    }

    public BundledProductSpecification(BundledProductSpecification bundledProdSpec) {
        this();
        this.name = bundledProdSpec.getName();
        this.lifecycleStatus = bundledProdSpec.getLifecycleStatus();
    }

    public BundledProductSpecification id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the product specification")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BundledProductSpecification href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Reference of the product specification")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public BundledProductSpecification lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Override
    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    @Override
    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    @Override
    public BundledProductSpecification name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the product specification")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public BundledProductSpecification baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public BundledProductSpecification schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Override
    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public BundledProductSpecification type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundledProductSpecification bundledProductSpecification = (BundledProductSpecification)o;
        return Objects.equals(this.id, bundledProductSpecification.id) && Objects.equals(this.href, bundledProductSpecification.href) && Objects.equals(this.lifecycleStatus, bundledProductSpecification.lifecycleStatus) && Objects.equals(this.name, bundledProductSpecification.name) && Objects.equals(this.baseType, bundledProductSpecification.baseType) && Objects.equals(this.schemaLocation, bundledProductSpecification.schemaLocation) && Objects.equals(this.type, bundledProductSpecification.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.lifecycleStatus, this.name, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BundledProductSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void updateWith(BundledProductSpecification src) {
        this.name = src.getName();
        this.lifecycleStatus = src.getLifecycleStatus();
    }
}

