/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="A set of numbers that specifies the lower and upper limits for a ProductOffering that can be procured as part of the related BundledProductOffering. Values can range from 0 to unbounded")
@Validated
@Entity(name="BundledProductOfferingOption")
public class BundledProductOfferingOption
extends BaseRootEntity {
    @JsonProperty(value="numberRelOfferDefault")
    private Integer numberRelOfferDefault = null;
    @JsonProperty(value="numberRelOfferLowerLimit")
    private Integer numberRelOfferLowerLimit = null;
    @JsonProperty(value="numberRelOfferUpperLimit")
    private Integer numberRelOfferUpperLimit = null;

    public BundledProductOfferingOption numberRelOfferDefault(Integer numberRelOfferDefault) {
        this.numberRelOfferDefault = numberRelOfferDefault;
        return this;
    }

    @Schema(description="Default number of produc offereings that should be procured as part of the related BundledProductOffering")
    public Integer getNumberRelOfferDefault() {
        return this.numberRelOfferDefault;
    }

    public void setNumberRelOfferDefault(Integer numberRelOfferDefault) {
        this.numberRelOfferDefault = numberRelOfferDefault;
    }

    public BundledProductOfferingOption numberRelOfferLowerLimit(Integer numberRelOfferLowerLimit) {
        this.numberRelOfferLowerLimit = numberRelOfferLowerLimit;
        return this;
    }

    @Schema(description="lower limit for a product offering that can be procured as part of the related BundledProductOffering")
    public Integer getNumberRelOfferLowerLimit() {
        return this.numberRelOfferLowerLimit;
    }

    public void setNumberRelOfferLowerLimit(Integer numberRelOfferLowerLimit) {
        this.numberRelOfferLowerLimit = numberRelOfferLowerLimit;
    }

    public BundledProductOfferingOption numberRelOfferUpperLimit(Integer numberRelOfferUpperLimit) {
        this.numberRelOfferUpperLimit = numberRelOfferUpperLimit;
        return this;
    }

    @Schema(description="upper limit for a product offering that can be procured as part of the related BundledProductOffering")
    public Integer getNumberRelOfferUpperLimit() {
        return this.numberRelOfferUpperLimit;
    }

    public void setNumberRelOfferUpperLimit(Integer numberRelOfferUpperLimit) {
        this.numberRelOfferUpperLimit = numberRelOfferUpperLimit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundledProductOfferingOption bundledProductOfferingOption = (BundledProductOfferingOption)o;
        return Objects.equals(this.numberRelOfferDefault, bundledProductOfferingOption.numberRelOfferDefault) && Objects.equals(this.numberRelOfferLowerLimit, bundledProductOfferingOption.numberRelOfferLowerLimit) && Objects.equals(this.numberRelOfferUpperLimit, bundledProductOfferingOption.numberRelOfferUpperLimit) && Objects.equals(this.baseType, bundledProductOfferingOption.baseType) && Objects.equals(this.schemaLocation, bundledProductOfferingOption.schemaLocation) && Objects.equals(this.type, bundledProductOfferingOption.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BundledProductOfferingOption {\n");
        sb.append("    numberRelOfferDefault: ").append(this.toIndentedString(this.numberRelOfferDefault)).append("\n");
        sb.append("    numberRelOfferLowerLimit: ").append(this.toIndentedString(this.numberRelOfferLowerLimit)).append("\n");
        sb.append("    numberRelOfferUpperLimit: ").append(this.toIndentedString(this.numberRelOfferUpperLimit)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

