/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pcm620.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.pcm620.model.BundledProductOfferingOption;
import org.springframework.validation.annotation.Validated;

@Schema(description="A type of ProductOffering that belongs to a grouping of ProductOfferings made available to the market. It inherits of all attributes of ProductOffering.")
@Validated
@Entity(name="BundledProductOffering")
public class BundledProductOffering
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="bundledProductOfferingOption")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinColumn(referencedColumnName="uuid")
    private BundledProductOfferingOption bundledProductOfferingOption = null;

    @Schema(description="Unique identifier of a related entity.")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    @Schema(description="Unique reference of the BundledProductOffering")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public BundledProductOffering lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Override
    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    @Override
    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    @Override
    public BundledProductOffering name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the BundledProductOffering")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public BundledProductOffering bundledProductOfferingOption(BundledProductOfferingOption bundledProductOfferingOption) {
        this.bundledProductOfferingOption = bundledProductOfferingOption;
        return this;
    }

    @Schema(description="A set of numbers that specifies the lower and upper limits for a ProductOffering that can be procured as part of the related BundledProductOffering. Values can range from 0 to unbounded.")
    @Valid
    public BundledProductOfferingOption getBundledProductOfferingOption() {
        return this.bundledProductOfferingOption;
    }

    public void setBundledProductOfferingOption(BundledProductOfferingOption bundledProductOfferingOption) {
        this.bundledProductOfferingOption = bundledProductOfferingOption;
    }

    @Override
    public BundledProductOffering baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public BundledProductOffering schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Override
    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public BundledProductOffering type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundledProductOffering bundledProductOffering = (BundledProductOffering)o;
        return Objects.equals(this.id, bundledProductOffering.id) && Objects.equals(this.href, bundledProductOffering.href) && Objects.equals(this.lifecycleStatus, bundledProductOffering.lifecycleStatus) && Objects.equals(this.name, bundledProductOffering.name) && Objects.equals(this.bundledProductOfferingOption, bundledProductOffering.bundledProductOfferingOption) && Objects.equals(this.baseType, bundledProductOffering.baseType) && Objects.equals(this.schemaLocation, bundledProductOffering.schemaLocation) && Objects.equals(this.type, bundledProductOffering.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BundledProductOffering {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    bundledProductOfferingOption: ").append(this.toIndentedString(this.bundledProductOfferingOption)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

