/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.lcm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.lcm.model.ELCMRulePhase;
import org.springframework.validation.annotation.Validated;

@Schema(description="A LCM RuleSpecification is an entity that describes a LCM rule to apply during the LCM of a service.")
@Validated
@Entity(name="LCMRuleSpec")
public class LCMRuleSpecification
extends BaseEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="lcmrulephase")
    protected String lcmrulephase = ELCMRulePhase.PRE_PROVISION.getValue();
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.DETACH, CascadeType.REFRESH})
    @JsonIgnore
    private Set<ServiceSpecificationRef> serviceSpecs = new HashSet<ServiceSpecificationRef>();
    @Lob
    @Column(name="LCONTENT", columnDefinition="LONGTEXT")
    @JsonProperty(value="content")
    protected String content = null;
    @Lob
    @Column(name="LCODE", columnDefinition="LONGTEXT")
    @JsonProperty(value="code")
    protected String code = null;
    @JsonProperty(value="priority")
    protected int priority = 0;

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public void setId(String id) {
        id = this.uuid;
    }

    @Schema(description="List of service specs associated with this rule")
    @Transient
    @JsonProperty(value="serviceSpecs")
    @Valid
    public Set<ServiceSpecificationRef> getServiceSpecs() {
        return this.serviceSpecs;
    }

    public void addServiceSpecificationRef(ServiceSpecificationRef s) {
        if (!this.serviceSpecs.contains(s)) {
            this.serviceSpecs.add(s);
        }
    }

    public void setServiceSpecs(Set<ServiceSpecificationRef> serviceSpecs) {
        this.serviceSpecs = serviceSpecs;
    }

    @Override
    public void copyFromObj(BaseEntity be) {
        super.copyFromObj(be);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getLcmrulephase() {
        return this.lcmrulephase;
    }

    public void setLcmrulephase(String lcmrulephase) {
        this.lcmrulephase = lcmrulephase;
    }

    public void setLcmrulephase(ELCMRulePhase lcmrulephase) {
        this.lcmrulephase = lcmrulephase.getValue();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LCMRuleSpecification)) {
            return false;
        }
        LCMRuleSpecification other = (LCMRuleSpecification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lcmrulephase = this.getLcmrulephase();
        String other$lcmrulephase = other.getLcmrulephase();
        if (this$lcmrulephase == null ? other$lcmrulephase != null : !this$lcmrulephase.equals(other$lcmrulephase)) {
            return false;
        }
        Set<ServiceSpecificationRef> this$serviceSpecs = this.getServiceSpecs();
        Set<ServiceSpecificationRef> other$serviceSpecs = other.getServiceSpecs();
        if (this$serviceSpecs == null ? other$serviceSpecs != null : !((Object)this$serviceSpecs).equals(other$serviceSpecs)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LCMRuleSpecification;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPriority();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lcmrulephase = this.getLcmrulephase();
        result = result * 59 + ($lcmrulephase == null ? 43 : $lcmrulephase.hashCode());
        Set<ServiceSpecificationRef> $serviceSpecs = this.getServiceSpecs();
        result = result * 59 + ($serviceSpecs == null ? 43 : ((Object)$serviceSpecs).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }
}

