/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Schema(name="Reference", description="Reference schema .")
public class Reference {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="@referredType")
    private String atReferredType;

    public Reference() {
    }

    public Reference(String id) {
        this.id = id;
    }

    public Reference id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="Identifier of the referred entity.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Reference name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Name of the referred entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Reference atReferredType(String atReferredType) {
        this.atReferredType = atReferredType;
        return this;
    }

    @Schema(name="@referredType", description="The actual type of the target instance when needed for disambiguation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtReferredType() {
        return this.atReferredType;
    }

    public void setAtReferredType(String atReferredType) {
        this.atReferredType = atReferredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference reference = (Reference)o;
        return Objects.equals(this.id, reference.id) && Objects.equals(this.name, reference.name) && Objects.equals(this.atReferredType, reference.atReferredType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.atReferredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reference {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    atReferredType: ").append(this.toIndentedString(this.atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

