/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.gsm674.model.GeographicSubAddressUnit;

@Entity(name="GeoSubAddVal")
@Table(name="GeoSubAddVal")
public class GeographicSubAddressValue
extends BaseRootEntity {
    @JsonProperty(value="buildingName")
    private String buildingName;
    @JsonProperty(value="levelNumber")
    private String levelNumber;
    @JsonProperty(value="levelType")
    private String levelType;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="privateStreetName")
    private String privateStreetName;
    @JsonProperty(value="privateStreetNumber")
    private String privateStreetNumber;
    @Valid
    @JsonProperty(value="subUnit")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private List<GeographicSubAddressUnit> subUnit = new ArrayList<GeographicSubAddressUnit>();
    @JsonProperty(value="subAddressType")
    private String subAddressType;

    public GeographicSubAddressValue() {
    }

    public GeographicSubAddressValue(String atType) {
        this.type = atType;
    }

    public GeographicSubAddressValue atType(String atType) {
        this.type = atType;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String atType) {
        this.type = atType;
    }

    public GeographicSubAddressValue atBaseType(String atBaseType) {
        this.baseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.baseType = atBaseType;
    }

    public GeographicSubAddressValue atSchemaLocation(String atSchemaLocation) {
        this.schemaLocation = atSchemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String atSchemaLocation) {
        this.schemaLocation = atSchemaLocation;
    }

    public GeographicSubAddressValue buildingName(String buildingName) {
        this.buildingName = buildingName;
        return this;
    }

    @Schema(name="buildingName", description="allows for buildings that have well-known names", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBuildingName() {
        return this.buildingName;
    }

    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    public GeographicSubAddressValue levelNumber(String levelNumber) {
        this.levelNumber = levelNumber;
        return this;
    }

    @Schema(name="levelNumber", description="used where a level type may be repeated e.g. BASEMENT 1, BASEMENT 2", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getLevelNumber() {
        return this.levelNumber;
    }

    public void setLevelNumber(String levelNumber) {
        this.levelNumber = levelNumber;
    }

    public GeographicSubAddressValue levelType(String levelType) {
        this.levelType = levelType;
        return this;
    }

    @Schema(name="levelType", description="describes level types within a building", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getLevelType() {
        return this.levelType;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public GeographicSubAddressValue name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Name of the subAddress to identify it with a meaningful identification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GeographicSubAddressValue privateStreetName(String privateStreetName) {
        this.privateStreetName = privateStreetName;
        return this;
    }

    @Schema(name="privateStreetName", description="private streets internal to a property (e.g. a university) may have internal names that are not recorded by the land title office.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getPrivateStreetName() {
        return this.privateStreetName;
    }

    public void setPrivateStreetName(String privateStreetName) {
        this.privateStreetName = privateStreetName;
    }

    public GeographicSubAddressValue privateStreetNumber(String privateStreetNumber) {
        this.privateStreetNumber = privateStreetNumber;
        return this;
    }

    @Schema(name="privateStreetNumber", description="private streets numbers internal to a private street", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getPrivateStreetNumber() {
        return this.privateStreetNumber;
    }

    public void setPrivateStreetNumber(String privateStreetNumber) {
        this.privateStreetNumber = privateStreetNumber;
    }

    public GeographicSubAddressValue subUnit(List<GeographicSubAddressUnit> subUnit) {
        this.subUnit = subUnit;
        return this;
    }

    public GeographicSubAddressValue addSubUnitItem(GeographicSubAddressUnit subUnitItem) {
        if (this.subUnit == null) {
            this.subUnit = new ArrayList<GeographicSubAddressUnit>();
        }
        this.subUnit.add(subUnitItem);
        return this;
    }

    @Valid
    @Schema(name="subUnit", description="Representation of a SubUnit. It is used for describing subunit within a subAddress e.g. BERTH, FLAT, PIER, SUITE, SHOP, TOWER, UNIT, WHARF.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<GeographicSubAddressUnit> getSubUnit() {
        return this.subUnit;
    }

    public void setSubUnit(List<GeographicSubAddressUnit> subUnit) {
        this.subUnit = subUnit;
    }

    public GeographicSubAddressValue subAddressType(String subAddressType) {
        this.subAddressType = subAddressType;
        return this;
    }

    @Schema(name="subAddressType", description="Type of subAddress : it can be a subunit or a private street", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSubAddressType() {
        return this.subAddressType;
    }

    public void setSubAddressType(String subAddressType) {
        this.subAddressType = subAddressType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeographicSubAddressValue geographicSubAddressValue = (GeographicSubAddressValue)o;
        return Objects.equals(this.type, geographicSubAddressValue.type) && Objects.equals(this.baseType, geographicSubAddressValue.baseType) && Objects.equals(this.schemaLocation, geographicSubAddressValue.schemaLocation) && Objects.equals(this.buildingName, geographicSubAddressValue.buildingName) && Objects.equals(this.levelNumber, geographicSubAddressValue.levelNumber) && Objects.equals(this.levelType, geographicSubAddressValue.levelType) && Objects.equals(this.name, geographicSubAddressValue.name) && Objects.equals(this.privateStreetName, geographicSubAddressValue.privateStreetName) && Objects.equals(this.privateStreetNumber, geographicSubAddressValue.privateStreetNumber) && Objects.equals(this.subUnit, geographicSubAddressValue.subUnit) && Objects.equals(this.subAddressType, geographicSubAddressValue.subAddressType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.buildingName, this.levelNumber, this.levelType, this.name, this.privateStreetName, this.privateStreetNumber, this.subUnit, this.subAddressType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeographicSubAddressValue {\n");
        sb.append("    @type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    @baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    @schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    buildingName: ").append(this.toIndentedString(this.buildingName)).append("\n");
        sb.append("    levelNumber: ").append(this.toIndentedString(this.levelNumber)).append("\n");
        sb.append("    levelType: ").append(this.toIndentedString(this.levelType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    privateStreetName: ").append(this.toIndentedString(this.privateStreetName)).append("\n");
        sb.append("    privateStreetNumber: ").append(this.toIndentedString(this.privateStreetNumber)).append("\n");
        sb.append("    subUnit: ").append(this.toIndentedString(this.subUnit)).append("\n");
        sb.append("    subAddressType: ").append(this.toIndentedString(this.subAddressType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

