/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;

@Entity(name="GeoSubAddUnit")
@Table(name="GeoSubAddUnit")
public class GeographicSubAddressUnit
extends BaseRootEntity {
    @JsonProperty(value="subUnitNumber")
    private String subUnitNumber;
    @JsonProperty(value="subUnitType")
    private String subUnitType;

    public GeographicSubAddressUnit() {
    }

    public GeographicSubAddressUnit(String subUnitNumber, String subUnitType) {
        this.subUnitNumber = subUnitNumber;
        this.subUnitType = subUnitType;
    }

    public GeographicSubAddressUnit atSchemaLocation(String atSchemaLocation) {
        this.schemaLocation = atSchemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String atSchemaLocation) {
        this.schemaLocation = atSchemaLocation;
    }

    public GeographicSubAddressUnit atBaseType(String atBaseType) {
        this.baseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.baseType = atBaseType;
    }

    public GeographicSubAddressUnit atType(String atType) {
        this.type = atType;
        return this;
    }

    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String atType) {
        this.type = atType;
    }

    public GeographicSubAddressUnit subUnitNumber(String subUnitNumber) {
        this.subUnitNumber = subUnitNumber;
        return this;
    }

    @NotNull
    @Schema(name="subUnitNumber", description="The discriminator used for the subunit, often just a simple number but may also be a range.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getSubUnitNumber() {
        return this.subUnitNumber;
    }

    public void setSubUnitNumber(String subUnitNumber) {
        this.subUnitNumber = subUnitNumber;
    }

    public GeographicSubAddressUnit subUnitType(String subUnitType) {
        this.subUnitType = subUnitType;
        return this;
    }

    @NotNull
    @Schema(name="subUnitType", description="The type of subunit e.g.BERTH, FLAT, PIER, SUITE, SHOP, TOWER, UNIT, WHARF, RACK", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getSubUnitType() {
        return this.subUnitType;
    }

    public void setSubUnitType(String subUnitType) {
        this.subUnitType = subUnitType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeographicSubAddressUnit geographicSubAddressUnit = (GeographicSubAddressUnit)o;
        return Objects.equals(this.schemaLocation, geographicSubAddressUnit.schemaLocation) && Objects.equals(this.baseType, geographicSubAddressUnit.baseType) && Objects.equals(this.type, geographicSubAddressUnit.type) && Objects.equals(this.subUnitNumber, geographicSubAddressUnit.subUnitNumber) && Objects.equals(this.subUnitType, geographicSubAddressUnit.subUnitType);
    }

    public int hashCode() {
        return Objects.hash(this.schemaLocation, this.baseType, this.type, this.subUnitNumber, this.subUnitType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeographicSubAddressUnit {\n");
        sb.append("    @schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    @baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    @type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    subUnitNumber: ").append(this.toIndentedString(this.subUnitNumber)).append("\n");
        sb.append("    subUnitType: ").append(this.toIndentedString(this.subUnitType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

