/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.gsm674.model.CalendarPeriod;
import org.etsi.osl.tmf.gsm674.model.ExternalIdentifier;
import org.etsi.osl.tmf.gsm674.model.GeographicSiteRelationship;
import org.etsi.osl.tmf.gsm674.model.PlaceRefOrValue;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.format.annotation.DateTimeFormat;

public class GeographicSiteUpdate {
    @JsonProperty(value="@type")
    private String atType;
    @JsonProperty(value="@baseType")
    private String atBaseType;
    @JsonProperty(value="@schemaLocation")
    private String atSchemaLocation;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="creationDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime creationDate;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="status")
    private String status;
    @Valid
    @JsonProperty(value="relatedParty")
    private List<RelatedParty> relatedParty = new ArrayList<RelatedParty>();
    @Valid
    @JsonProperty(value="externalIdentifier")
    private List<ExternalIdentifier> externalIdentifier = new ArrayList<ExternalIdentifier>();
    @Valid
    @JsonProperty(value="calendar")
    private List<CalendarPeriod> calendar = new ArrayList<CalendarPeriod>();
    @Valid
    @JsonProperty(value="place")
    private List<PlaceRefOrValue> place = new ArrayList<PlaceRefOrValue>();
    @Valid
    @JsonProperty(value="siteRelationship")
    private List<GeographicSiteRelationship> siteRelationship = new ArrayList<GeographicSiteRelationship>();

    public GeographicSiteUpdate() {
    }

    public GeographicSiteUpdate(String atType) {
        this.atType = atType;
    }

    public GeographicSiteUpdate atType(String atType) {
        this.atType = atType;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getAtType() {
        return this.atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public GeographicSiteUpdate atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtBaseType() {
        return this.atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public GeographicSiteUpdate atSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtSchemaLocation() {
        return this.atSchemaLocation;
    }

    public void setAtSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public GeographicSiteUpdate code(String code) {
        this.code = code;
        return this;
    }

    @Schema(name="code", description="A code that may be used for some addressing schemes eg: [ANSI T1.253-1999]", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public GeographicSiteUpdate creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Valid
    @Schema(name="creationDate", description="Date and time when the GeographicSite was created", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public GeographicSiteUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Text describing additional information regarding the site", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GeographicSiteUpdate status(String status) {
        this.status = status;
        return this;
    }

    @Schema(name="status", description="The condition of the GeographicSite, such as planned, underConstruction, cancelled, active, inactive, former", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public GeographicSiteUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public GeographicSiteUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Valid
    @Schema(name="relatedParty", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public GeographicSiteUpdate externalIdentifier(List<ExternalIdentifier> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    public GeographicSiteUpdate addExternalIdentifierItem(ExternalIdentifier externalIdentifierItem) {
        if (this.externalIdentifier == null) {
            this.externalIdentifier = new ArrayList<ExternalIdentifier>();
        }
        this.externalIdentifier.add(externalIdentifierItem);
        return this;
    }

    @Valid
    @Schema(name="externalIdentifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<ExternalIdentifier> getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(List<ExternalIdentifier> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public GeographicSiteUpdate calendar(List<CalendarPeriod> calendar) {
        this.calendar = calendar;
        return this;
    }

    public GeographicSiteUpdate addCalendarItem(CalendarPeriod calendarItem) {
        if (this.calendar == null) {
            this.calendar = new ArrayList<CalendarPeriod>();
        }
        this.calendar.add(calendarItem);
        return this;
    }

    @Valid
    @Schema(name="calendar", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CalendarPeriod> getCalendar() {
        return this.calendar;
    }

    public void setCalendar(List<CalendarPeriod> calendar) {
        this.calendar = calendar;
    }

    public GeographicSiteUpdate place(List<PlaceRefOrValue> place) {
        this.place = place;
        return this;
    }

    public GeographicSiteUpdate addPlaceItem(PlaceRefOrValue placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<PlaceRefOrValue>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Valid
    @Schema(name="place", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<PlaceRefOrValue> getPlace() {
        return this.place;
    }

    public void setPlace(List<PlaceRefOrValue> place) {
        this.place = place;
    }

    public GeographicSiteUpdate siteRelationship(List<GeographicSiteRelationship> siteRelationship) {
        this.siteRelationship = siteRelationship;
        return this;
    }

    public GeographicSiteUpdate addSiteRelationshipItem(GeographicSiteRelationship siteRelationshipItem) {
        if (this.siteRelationship == null) {
            this.siteRelationship = new ArrayList<GeographicSiteRelationship>();
        }
        this.siteRelationship.add(siteRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="siteRelationship", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<GeographicSiteRelationship> getSiteRelationship() {
        return this.siteRelationship;
    }

    public void setSiteRelationship(List<GeographicSiteRelationship> siteRelationship) {
        this.siteRelationship = siteRelationship;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeographicSiteUpdate geographicSiteUpdate = (GeographicSiteUpdate)o;
        return Objects.equals(this.atType, geographicSiteUpdate.atType) && Objects.equals(this.atBaseType, geographicSiteUpdate.atBaseType) && Objects.equals(this.atSchemaLocation, geographicSiteUpdate.atSchemaLocation) && Objects.equals(this.code, geographicSiteUpdate.code) && Objects.equals(this.creationDate, geographicSiteUpdate.creationDate) && Objects.equals(this.description, geographicSiteUpdate.description) && Objects.equals(this.status, geographicSiteUpdate.status) && Objects.equals(this.relatedParty, geographicSiteUpdate.relatedParty) && Objects.equals(this.externalIdentifier, geographicSiteUpdate.externalIdentifier) && Objects.equals(this.calendar, geographicSiteUpdate.calendar) && Objects.equals(this.place, geographicSiteUpdate.place) && Objects.equals(this.siteRelationship, geographicSiteUpdate.siteRelationship);
    }

    public int hashCode() {
        return Objects.hash(this.atType, this.atBaseType, this.atSchemaLocation, this.code, this.creationDate, this.description, this.status, this.relatedParty, this.externalIdentifier, this.calendar, this.place, this.siteRelationship);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeographicSiteUpdate {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.atType)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.atSchemaLocation)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    calendar: ").append(this.toIndentedString(this.calendar)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    siteRelationship: ").append(this.toIndentedString(this.siteRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

