/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;

@Entity(name="GeographicSiteRelationship")
public class GeographicSiteRelationship
extends BaseRootEntity {
    @JsonProperty(value="relationshipType")
    private String relationshipType;
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="validFor")
    private TimePeriod validFor;

    public GeographicSiteRelationship() {
    }

    public GeographicSiteRelationship(String id, String relationshipType) {
        this.id = id;
        this.relationshipType = relationshipType;
    }

    @Schema(name="role", description="Role of the related site in the relationship", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="role")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public GeographicSiteRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Valid
    @Schema(name="validFor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="validFor")
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public GeographicSiteRelationship id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="Unique identifier of the related site entity within the server", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GeographicSiteRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @NotNull
    @Schema(name="relationshipType", description="Type of relationship", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="relationshipType")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeographicSiteRelationship geographicSiteRelationship = (GeographicSiteRelationship)o;
        return Objects.equals(this.schemaLocation, geographicSiteRelationship.schemaLocation) && Objects.equals(this.baseType, geographicSiteRelationship.baseType) && Objects.equals(this.type, geographicSiteRelationship.type) && Objects.equals(this.href, geographicSiteRelationship.href) && Objects.equals(this.role, geographicSiteRelationship.role) && Objects.equals(this.validFor, geographicSiteRelationship.validFor) && Objects.equals(this.id, geographicSiteRelationship.id) && Objects.equals(this.relationshipType, geographicSiteRelationship.relationshipType);
    }

    public int hashCode() {
        return Objects.hash(this.schemaLocation, this.baseType, this.type, this.href, this.role, this.validFor, this.id, this.relationshipType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeographicSiteRelationship {\n");
        sb.append("    @schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    @baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    @type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

