/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.gsm674.model.CalendarPeriod;
import org.etsi.osl.tmf.gsm674.model.ExternalIdentifier;
import org.etsi.osl.tmf.gsm674.model.GeographicSiteRelationship;
import org.etsi.osl.tmf.gsm674.model.PatchGeographicSite200Response;
import org.etsi.osl.tmf.gsm674.model.PlaceRefOrValue;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.format.annotation.DateTimeFormat;

@Entity(name="GeographicSite")
public class GeographicSite
extends BaseRootEntity
implements PatchGeographicSite200Response {
    @JsonProperty(value="creationDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime creationDate;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="externalIdentifier")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private List<ExternalIdentifier> externalIdentifier = new ArrayList<ExternalIdentifier>();
    @JsonProperty(value="calendar")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private List<CalendarPeriod> calendar = new ArrayList<CalendarPeriod>();
    @JsonProperty(value="place")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private List<PlaceRefOrValue> place = new ArrayList<PlaceRefOrValue>();
    @JsonProperty(value="siteRelationship")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private List<GeographicSiteRelationship> siteRelationship = new ArrayList<GeographicSiteRelationship>();
    @JsonProperty(value="relatedParty")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private List<RelatedParty> relatedParty = new ArrayList<RelatedParty>();

    public GeographicSite code(String code) {
        this.code = code;
        return this;
    }

    @Schema(name="code", description="A code that may be used for some addressing schemes eg: [ANSI T1.253-1999]", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public GeographicSite creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Valid
    @Schema(name="creationDate", description="Date and time when the GeographicSite was created", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public GeographicSite description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Text describing additional information regarding the site", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GeographicSite status(String status) {
        this.status = status;
        return this;
    }

    @Schema(name="status", description="The condition of the GeographicSite, such as planned, underConstruction, cancelled, active, inactive, former", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public GeographicSite relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public GeographicSite addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Valid
    @Schema(name="relatedParty", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public GeographicSite externalIdentifier(List<ExternalIdentifier> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    public GeographicSite addExternalIdentifierItem(ExternalIdentifier externalIdentifierItem) {
        if (this.externalIdentifier == null) {
            this.externalIdentifier = new ArrayList<ExternalIdentifier>();
        }
        this.externalIdentifier.add(externalIdentifierItem);
        return this;
    }

    @Valid
    @Schema(name="externalIdentifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<ExternalIdentifier> getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(List<ExternalIdentifier> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public GeographicSite calendar(List<CalendarPeriod> calendar) {
        this.calendar = calendar;
        return this;
    }

    public GeographicSite addCalendarItem(CalendarPeriod calendarItem) {
        if (this.calendar == null) {
            this.calendar = new ArrayList<CalendarPeriod>();
        }
        this.calendar.add(calendarItem);
        return this;
    }

    @Valid
    @Schema(name="calendar", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CalendarPeriod> getCalendar() {
        return this.calendar;
    }

    public void setCalendar(List<CalendarPeriod> calendar) {
        this.calendar = calendar;
    }

    public GeographicSite place(List<PlaceRefOrValue> place) {
        this.place = place;
        return this;
    }

    public GeographicSite addPlaceItem(PlaceRefOrValue placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<PlaceRefOrValue>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Valid
    @Schema(name="place", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<PlaceRefOrValue> getPlace() {
        return this.place;
    }

    public void setPlace(List<PlaceRefOrValue> place) {
        this.place = place;
    }

    public GeographicSite siteRelationship(List<GeographicSiteRelationship> siteRelationship) {
        this.siteRelationship = siteRelationship;
        return this;
    }

    public GeographicSite addSiteRelationshipItem(GeographicSiteRelationship siteRelationshipItem) {
        if (this.siteRelationship == null) {
            this.siteRelationship = new ArrayList<GeographicSiteRelationship>();
        }
        this.siteRelationship.add(siteRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="siteRelationship", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<GeographicSiteRelationship> getSiteRelationship() {
        return this.siteRelationship;
    }

    public void setSiteRelationship(List<GeographicSiteRelationship> siteRelationship) {
        this.siteRelationship = siteRelationship;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeographicSite geographicSite = (GeographicSite)o;
        return Objects.equals(this.code, geographicSite.code) && Objects.equals(this.creationDate, geographicSite.creationDate) && Objects.equals(this.description, geographicSite.description) && Objects.equals(this.status, geographicSite.status) && Objects.equals(this.relatedParty, geographicSite.relatedParty) && Objects.equals(this.externalIdentifier, geographicSite.externalIdentifier) && Objects.equals(this.calendar, geographicSite.calendar) && Objects.equals(this.place, geographicSite.place) && Objects.equals(this.siteRelationship, geographicSite.siteRelationship) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.creationDate, this.description, this.status, this.relatedParty, this.externalIdentifier, this.calendar, this.place, this.siteRelationship, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeographicSite {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    calendar: ").append(this.toIndentedString(this.calendar)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    siteRelationship: ").append(this.toIndentedString(this.siteRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

