/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.gsm674.model.GeographicSubAddressValue;
import org.etsi.osl.tmf.gsm674.model.PlaceRefOrValue;

@Entity(name="GeographicAddress")
public class GeographicAddressValue
extends PlaceRefOrValue {
    @JsonProperty(value="locality")
    private String locality;
    @JsonProperty(value="postcode")
    private String postcode;
    @JsonProperty(value="stateOrProvince")
    private String stateOrProvince;
    @JsonProperty(value="streetNr")
    private String streetNr;
    @JsonProperty(value="streetNrLast")
    private String streetNrLast;
    @JsonProperty(value="streetNrLastSuffix")
    private String streetNrLastSuffix;
    @JsonProperty(value="streetNrSuffix")
    private String streetNrSuffix;
    @JsonProperty(value="streetSuffix")
    private String streetSuffix;
    @JsonProperty(value="streetType")
    private String streetType;
    @JsonProperty(value="geographicSubAddress")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private GeographicSubAddressValue geographicSubAddress;
    @JsonProperty(value="city")
    private String city;
    @JsonProperty(value="country")
    private String country;
    @JsonProperty(value="streetName")
    private String streetName;

    public GeographicAddressValue locality(String locality) {
        this.locality = locality;
        return this;
    }

    @Schema(name="locality", description="An area of defined or undefined boundaries within a local authority or other legislatively defined area, usually rural or semi rural in nature. [ANZLIC-STREET], or a suburb, a bounded locality within a city, town or shire principally of urban character [ANZLICSTREET]", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public GeographicAddressValue postcode(String postcode) {
        this.postcode = postcode;
        return this;
    }

    @Schema(name="postcode", description="descriptor for a postal delivery area, used to speed and simplify the delivery of mail (also know as zipcode)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public GeographicAddressValue stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @Schema(name="stateOrProvince", description="the State or Province that the address is in", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public GeographicAddressValue streetNr(String streetNr) {
        this.streetNr = streetNr;
        return this;
    }

    @Schema(name="streetNr", description="Number identifying a specific property on a public street. It may be combined with streetNrLast for ranged addresses", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStreetNr() {
        return this.streetNr;
    }

    public void setStreetNr(String streetNr) {
        this.streetNr = streetNr;
    }

    public GeographicAddressValue streetNrLast(String streetNrLast) {
        this.streetNrLast = streetNrLast;
        return this;
    }

    @Schema(name="streetNrLast", description="Last number in a range of street numbers allocated to a property", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStreetNrLast() {
        return this.streetNrLast;
    }

    public void setStreetNrLast(String streetNrLast) {
        this.streetNrLast = streetNrLast;
    }

    public GeographicAddressValue streetNrLastSuffix(String streetNrLastSuffix) {
        this.streetNrLastSuffix = streetNrLastSuffix;
        return this;
    }

    @Schema(name="streetNrLastSuffix", description="Last street number suffix for a ranged address", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStreetNrLastSuffix() {
        return this.streetNrLastSuffix;
    }

    public void setStreetNrLastSuffix(String streetNrLastSuffix) {
        this.streetNrLastSuffix = streetNrLastSuffix;
    }

    public GeographicAddressValue streetNrSuffix(String streetNrSuffix) {
        this.streetNrSuffix = streetNrSuffix;
        return this;
    }

    @Schema(name="streetNrSuffix", description="the first street number suffix", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStreetNrSuffix() {
        return this.streetNrSuffix;
    }

    public void setStreetNrSuffix(String streetNrSuffix) {
        this.streetNrSuffix = streetNrSuffix;
    }

    public GeographicAddressValue streetSuffix(String streetSuffix) {
        this.streetSuffix = streetSuffix;
        return this;
    }

    @Schema(name="streetSuffix", description="A modifier denoting a relative direction", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStreetSuffix() {
        return this.streetSuffix;
    }

    public void setStreetSuffix(String streetSuffix) {
        this.streetSuffix = streetSuffix;
    }

    public GeographicAddressValue streetType(String streetType) {
        this.streetType = streetType;
        return this;
    }

    @Schema(name="streetType", description="alley, avenue, boulevard, brae, crescent, drive, highway, lane, terrace, parade, place, tarn, way, wharf ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStreetType() {
        return this.streetType;
    }

    public void setStreetType(String streetType) {
        this.streetType = streetType;
    }

    public GeographicAddressValue geographicSubAddress(GeographicSubAddressValue geographicSubAddress) {
        this.geographicSubAddress = geographicSubAddress;
        return this;
    }

    @Valid
    @Schema(name="geographicSubAddress", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public GeographicSubAddressValue getGeographicSubAddress() {
        return this.geographicSubAddress;
    }

    public void setGeographicSubAddress(GeographicSubAddressValue geographicSubAddress) {
        this.geographicSubAddress = geographicSubAddress;
    }

    public GeographicAddressValue city(String city) {
        this.city = city;
        return this;
    }

    @Schema(name="city", description="City that the address is in", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public GeographicAddressValue country(String country) {
        this.country = country;
        return this;
    }

    @Schema(name="country", description="Country that the address is in", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public GeographicAddressValue streetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    @Schema(name="streetName", description="Name of the street or other street type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeographicAddressValue geographicAddressValue = (GeographicAddressValue)o;
        return Objects.equals(this.type, geographicAddressValue.type) && Objects.equals(this.baseType, geographicAddressValue.baseType) && Objects.equals(this.schemaLocation, geographicAddressValue.schemaLocation) && Objects.equals(this.locality, geographicAddressValue.locality) && Objects.equals(this.postcode, geographicAddressValue.postcode) && Objects.equals(this.stateOrProvince, geographicAddressValue.stateOrProvince) && Objects.equals(this.streetNr, geographicAddressValue.streetNr) && Objects.equals(this.streetNrLast, geographicAddressValue.streetNrLast) && Objects.equals(this.streetNrLastSuffix, geographicAddressValue.streetNrLastSuffix) && Objects.equals(this.streetNrSuffix, geographicAddressValue.streetNrSuffix) && Objects.equals(this.streetSuffix, geographicAddressValue.streetSuffix) && Objects.equals(this.streetType, geographicAddressValue.streetType) && Objects.equals(this.geographicSubAddress, geographicAddressValue.geographicSubAddress) && Objects.equals(this.city, geographicAddressValue.city) && Objects.equals(this.country, geographicAddressValue.country) && Objects.equals(this.streetName, geographicAddressValue.streetName) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.locality, this.postcode, this.stateOrProvince, this.streetNr, this.streetNrLast, this.streetNrLastSuffix, this.streetNrSuffix, this.streetSuffix, this.streetType, this.geographicSubAddress, this.city, this.country, this.streetName, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeographicAddressValue {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    @type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    @baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    @schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    locality: ").append(this.toIndentedString(this.locality)).append("\n");
        sb.append("    postcode: ").append(this.toIndentedString(this.postcode)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    streetNr: ").append(this.toIndentedString(this.streetNr)).append("\n");
        sb.append("    streetNrLast: ").append(this.toIndentedString(this.streetNrLast)).append("\n");
        sb.append("    streetNrLastSuffix: ").append(this.toIndentedString(this.streetNrLastSuffix)).append("\n");
        sb.append("    streetNrSuffix: ").append(this.toIndentedString(this.streetNrSuffix)).append("\n");
        sb.append("    streetSuffix: ").append(this.toIndentedString(this.streetSuffix)).append("\n");
        sb.append("    streetType: ").append(this.toIndentedString(this.streetType)).append("\n");
        sb.append("    geographicSubAddress: ").append(this.toIndentedString(this.geographicSubAddress)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    streetName: ").append(this.toIndentedString(this.streetName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

