/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.gsm674.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;

@Entity(name="ExternalIdentifier")
@Table(name="ExternalIdentifier")
public class ExternalIdentifier
extends BaseRootEntity {
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="externalIdentifierType")
    private String externalIdentifierType;
    @JsonProperty(value="id")
    private String id;

    public ExternalIdentifier() {
    }

    public ExternalIdentifier(String id) {
        this.id = id;
    }

    public ExternalIdentifier owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Schema(name="owner", example="MagentoCommerce", description="Name of the external system that owns the entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ExternalIdentifier externalIdentifierType(String externalIdentifierType) {
        this.externalIdentifierType = externalIdentifierType;
        return this;
    }

    @Schema(name="externalIdentifierType", example="ProductOrder", description="Type of the identification, typically would be the type of the entity within the external system", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getExternalIdentifierType() {
        return this.externalIdentifierType;
    }

    public void setExternalIdentifierType(String externalIdentifierType) {
        this.externalIdentifierType = externalIdentifierType;
    }

    public ExternalIdentifier id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="identification of the entity within the external system.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalIdentifier externalIdentifier = (ExternalIdentifier)o;
        return Objects.equals(this.schemaLocation, externalIdentifier.schemaLocation) && Objects.equals(this.baseType, externalIdentifier.baseType) && Objects.equals(this.type, externalIdentifier.type) && Objects.equals(this.owner, externalIdentifier.owner) && Objects.equals(this.externalIdentifierType, externalIdentifier.externalIdentifierType) && Objects.equals(this.id, externalIdentifier.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaLocation, this.baseType, this.type, this.owner, this.externalIdentifierType, this.id);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalIdentifier {\n");
        sb.append("    @schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    @baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    @type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    externalIdentifierType: ").append(this.toIndentedString(this.externalIdentifierType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

